
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="rotisserie_chickens")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")

# Set objective function
m.setObjective(6.51 * potatoes**2 + 6.3 * potatoes * rotisserie_chickens + 8.57 * rotisserie_chickens**2 + 3.48 * rotisserie_chickens * corn_cobs + 7.18 * corn_cobs**2 + 4.64 * rotisserie_chickens + 3.49 * corn_cobs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(-1 * rotisserie_chickens + 10 * corn_cobs >= 0, "c1")
m.addConstr(5.32 * potatoes + 0.57 * corn_cobs <= 47, "c2")
m.addConstr(5.14**2 * rotisserie_chickens**2 + 0.57**2 * corn_cobs**2 <= 67, "c3")
m.addConstr(5.32**2 * potatoes**2 + 5.14**2 * rotisserie_chickens**2 <= 74, "c4")
m.addConstr(5.32 * potatoes + 5.14 * rotisserie_chickens + 0.57 * corn_cobs <= 74, "c5")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potatoes:', potatoes.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
    print('corn_cobs:', corn_cobs.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

