
import gurobipy as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
potatoes = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="potatoes")
rotisserie_chickens = model.addVar(lb=0, ub=gp.GRB.INFINITY, type=gp.GRB.INTEGER, name="rotisserie_chickens")
corn_cobs = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="corn_cobs")

# Objective function
model.setObjective(6.51 * potatoes**2 + 6.3 * potatoes * rotisserie_chickens + 8.57 * rotisserie_chickens**2 + 
                   3.48 * rotisserie_chickens * corn_cobs + 7.18 * corn_cobs**2 + 4.64 * rotisserie_chickens + 
                   3.49 * corn_cobs, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(potatoes == 5.32, name="healthiness_rating_potatoes")
model.addConstr(rotisserie_chickens == 5.14, name="healthiness_rating_rotisserie_chickens")
model.addConstr(corn_cobs == 0.57, name="healthiness_rating_corn_cobs")

model.addConstr(-rotisserie_chickens + 10 * corn_cobs >= 0, name="rotisserie_chickens_corn_cobs_constraint")

# Healthiness rating constraints
model.addConstr(5.32 * potatoes + 0.57 * corn_cobs <= 47, name="potatoes_corn_cobs_healthiness")
model.addConstr(5.14**2 * rotisserie_chickens**2 + 0.57**2 * corn_cobs**2 <= 67, name="rotisserie_chickens_corn_cobs_healthiness_squared")
model.addConstr(5.32**2 * potatoes**2 + 5.14**2 * rotisserie_chickens**2 <= 74, name="potatoes_rotisserie_chickens_healthiness_squared")
model.addConstr(5.32 * potatoes + 5.14 * rotisserie_chickens + 0.57 * corn_cobs <= 74, name="total_healthiness")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Potatoes: {potatoes.varValue}")
    print(f"Rotisserie Chickens: {rotisserie_chickens.varValue}")
    print(f"Corn Cobs: {corn_cobs.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
