
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
Bill_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")
John_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")

# Objective function: Maximize
m.setObjective(5.02 * Bill_hours**2 + 4.37 * Bill_hours * John_hours + 3.47 * John_hours**2 + 3.78 * John_hours, GRB.MAXIMIZE)

# Constraints
m.addConstr(Bill_hours * 8 + John_hours * 13 >= 35) # Minimum total combined dollar cost per hour from hours worked by both squared
m.addConstr(Bill_hours * 2 + John_hours * 9 >= 41) # Minimum total combined work quality rating
m.addConstr(Bill_hours * 6 + John_hours * 12 >= 38) # Minimum total combined likelihood to quit index
m.addConstr(3 * Bill_hours - 6 * John_hours >= 0) # Linear inequality constraint

m.addConstr(Bill_hours**2 * 8 + John_hours**2 * 13 <= 123) # Maximum total combined dollar cost per hour from hours worked by both squared
m.addConstr(Bill_hours * 8 + John_hours * 13 <= 123) # Maximum total combined dollar cost per hour
m.addConstr(Bill_hours**2 * 2 + John_hours**2 * 9 <= 80) # Maximum total combined work quality rating from hours worked by both squared
m.addConstr(Bill_hours * 2 + John_hours * 9 <= 80) # Maximum total combined work quality rating
m.addConstr(Bill_hours * 6 + John_hours * 12 <= 71) # Maximum total combined likelihood to quit index

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {Bill_hours.X}")
    print(f"Hours worked by John: {John_hours.X}")
else:
    print("No optimal solution found")
