
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
hours_worked_by_Bill = m.addVar(name="hours_worked_by_Bill", integer=True)
hours_worked_by_John = m.addVar(name="hours_worked_by_John")

# Objective function
m.setObjective(5.02 * hours_worked_by_Bill ** 2 + 4.37 * hours_worked_by_Bill * hours_worked_by_John + 
               3.47 * hours_worked_by_John ** 2 + 3.78 * hours_worked_by_John, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(hours_worked_by_Bill ** 2 + hours_worked_by_John ** 2 >= 35)
m.addConstr(2 * hours_worked_by_Bill + 9 * hours_worked_by_John >= 41)
m.addConstr(6 * hours_worked_by_Bill + 12 * hours_worked_by_John >= 38)
m.addConstr(3 * hours_worked_by_Bill - 6 * hours_worked_by_John >= 0)
m.addConstr(hours_worked_by_Bill ** 2 + hours_worked_by_John ** 2 <= 123)
m.addConstr(8 * hours_worked_by_Bill + 13 * hours_worked_by_John <= 123)
m.addConstr(2 * hours_worked_by_Bill + 9 * hours_worked_by_John <= 80)
m.addConstr(6 * hours_worked_by_Bill + 12 * hours_worked_by_John <= 71)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.varValue}")
    print(f"Hours worked by John: {hours_worked_by_John.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
