
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximize Office Supplies")

# Define decision variables
lanyards = model.addVar(vtype=GRB.INTEGER, name="lanyards")
mechanical_pencils = model.addVar(vtype=GRB.INTEGER, name="mechanical_pencils")
red_pens = model.addVar(vtype=GRB.INTEGER, name="red_pens")
blue_pens = model.addVar(vtype=GRB.INTEGER, name="blue_pens")
monochrome_printers = model.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
packs_of_paper = model.addVar(vtype=GRB.INTEGER, name="packs_of_paper")
black_pens = model.addVar(vtype=GRB.INTEGER, name="black_pens")

# Set objective function
model.setObjective(4 * lanyards + 5 * mechanical_pencils + 5 * red_pens + 6 * blue_pens + 3 * monochrome_printers + 7 * packs_of_paper + 4 * black_pens, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * lanyards + 9 * mechanical_pencils >= 15, "c1")
model.addConstr(9 * red_pens + 10 * blue_pens >= 16, "c2")
model.addConstr(9 * mechanical_pencils + 7 * black_pens >= 25, "c3")
model.addConstr(6 * lanyards + 15 * packs_of_paper >= 12, "c4")
model.addConstr(9 * mechanical_pencils + 9 * red_pens >= 23, "c5")
model.addConstr(15 * packs_of_paper + 7 * black_pens >= 14, "c6")
model.addConstr(6 * lanyards + 7 * black_pens >= 25, "c7")
model.addConstr(10 * blue_pens + 4 * monochrome_printers >= 12, "c8")
model.addConstr(9 * red_pens + 15 * packs_of_paper >= 10, "c9")
model.addConstr(6 * lanyards + 10 * blue_pens >= 16, "c10")
model.addConstr(9 * mechanical_pencils + 4 * monochrome_printers >= 10, "c11")
model.addConstr(4 * monochrome_printers + 15 * packs_of_paper >= 17, "c12")
model.addConstr(10 * blue_pens + 15 * packs_of_paper >= 19, "c13")
model.addConstr(4 * monochrome_printers + 7 * black_pens >= 12, "c14")
model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 25, "c15")
model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 25, "c16")
model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 25, "c17")
model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 25, "c18")
model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 22, "c19")
model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 22, "c20")
model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 22, "c21")
model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 22, "c22")
model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 13, "c23") # Redundant given c15
model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 13, "c24") # Redundant given c16
model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 13, "c25") # Redundant given c17
model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 13, "c26") # Redundant given c18
model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 16, "c27") # Redundant given c19
model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 16, "c28") # Redundant given c20
model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 16, "c29") # Redundant given c21
model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 16, "c30") # Redundant given c22


model.addConstr(-4 * blue_pens + 10 * black_pens >= 0, "c31")
model.addConstr(6 * lanyards + 4 * monochrome_printers <= 40, "c32")
model.addConstr(9 * mechanical_pencils + 10 * blue_pens <= 136, "c33")
model.addConstr(4 * monochrome_printers + 15 * packs_of_paper <= 34, "c34")
model.addConstr(6 * lanyards + 10 * blue_pens <= 52, "c35")
model.addConstr(9 * red_pens + 7 * black_pens <= 141, "c36")
model.addConstr(15 * packs_of_paper + 7 * black_pens <= 108, "c37")
model.addConstr(9 * red_pens + 4 * monochrome_printers <= 104, "c38")
model.addConstr(9 * mechanical_pencils + 9 * red_pens <= 53, "c39")
model.addConstr(9 * red_pens + 15 * packs_of_paper <= 64, "c40")
model.addConstr(9 * mechanical_pencils + 15 * packs_of_paper <= 158, "c41")
model.addConstr(4 * monochrome_printers + 7 * black_pens <= 61, "c42")
model.addConstr(10 * blue_pens + 15 * packs_of_paper <= 35, "c43")  # Likely infeasible with c13
model.addConstr(6 * lanyards + 15 * packs_of_paper <= 116, "c44")
model.addConstr(6 * lanyards + 4 * monochrome_printers + 15 * packs_of_paper <= 120, "c45")
model.addConstr(6 * lanyards + 9 * mechanical_pencils + 9 * red_pens + 10 * blue_pens + 4 * monochrome_printers + 15 * packs_of_paper + 7 * black_pens <= 175, "c46") # Budget constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

