
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    lanyards = model.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
    mechanical_pencils = model.addVar(name="mechanical_pencils", vtype=gurobi.GRB.INTEGER)
    red_pens = model.addVar(name="red_pens", vtype=gurobi.GRB.INTEGER)
    blue_pens = model.addVar(name="blue_pens", vtype=gurobi.GRB.INTEGER)
    monochrome_printers = model.addVar(name="monochrome_printers", vtype=gurobi.GRB.INTEGER)
    packs_of_paper = model.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
    black_pens = model.addVar(name="black_pens", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4 * lanyards + 5 * mechanical_pencils + 5 * red_pens + 6 * blue_pens + 
                       3 * monochrome_printers + 7 * packs_of_paper + 4 * black_pens, 
                       gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * lanyards + 9 * mechanical_pencils + 9 * red_pens + 10 * blue_pens + 
                    4 * monochrome_printers + 15 * packs_of_paper + 7 * black_pens <= 175)

    model.addConstr(6 * lanyards + 9 * mechanical_pencils >= 15)
    model.addConstr(9 * red_pens + 10 * blue_pens >= 16)
    model.addConstr(9 * mechanical_pencils + 7 * black_pens >= 25)
    model.addConstr(6 * lanyards + 15 * packs_of_paper >= 12)
    model.addConstr(9 * mechanical_pencils + 9 * red_pens >= 23)
    model.addConstr(15 * packs_of_paper + 7 * black_pens >= 14)
    model.addConstr(6 * lanyards + 7 * black_pens >= 25)
    model.addConstr(10 * blue_pens + 4 * monochrome_printers >= 12)
    model.addConstr(9 * red_pens + 15 * packs_of_paper >= 10)
    model.addConstr(6 * lanyards + 10 * blue_pens >= 16)
    model.addConstr(9 * mechanical_pencils + 4 * monochrome_printers >= 10)
    model.addConstr(4 * monochrome_printers + 15 * packs_of_paper >= 17)
    model.addConstr(10 * blue_pens + 15 * packs_of_paper >= 19)
    model.addConstr(4 * monochrome_printers + 7 * black_pens >= 12)
    model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 25)
    model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 25)
    model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 25)
    model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 25)
    model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 22)
    model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 22)
    model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 22)
    model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 22)
    model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 13)
    model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 13)
    model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 13)
    model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 13)
    model.addConstr(9 * red_pens + 10 * blue_pens + 15 * packs_of_paper >= 16)
    model.addConstr(9 * red_pens + 4 * monochrome_printers + 7 * black_pens >= 16)
    model.addConstr(6 * lanyards + 4 * monochrome_printers + 7 * black_pens >= 16)
    model.addConstr(6 * lanyards + 9 * mechanical_pencils + 15 * packs_of_paper >= 16)

    model.addConstr(-4 * blue_pens + 10 * black_pens >= 0)

    model.addConstr(6 * lanyards + 4 * monochrome_printers <= 40)
    model.addConstr(9 * mechanical_pencils + 10 * blue_pens <= 136)
    model.addConstr(4 * monochrome_printers + 15 * packs_of_paper <= 34)
    model.addConstr(6 * lanyards + 10 * blue_pens <= 52)
    model.addConstr(9 * red_pens + 7 * black_pens <= 141)
    model.addConstr(15 * packs_of_paper + 7 * black_pens <= 108)
    model.addConstr(9 * red_pens + 4 * monochrome_printers <= 104)
    model.addConstr(9 * mechanical_pencils + 9 * red_pens <= 53)
    model.addConstr(9 * red_pens + 15 * packs_of_paper <= 64)
    model.addConstr(9 * mechanical_pencils + 15 * packs_of_paper <= 158)
    model.addConstr(4 * monochrome_printers + 7 * black_pens <= 61)
    model.addConstr(10 * blue_pens + 15 * packs_of_paper <= 35)
    model.addConstr(6 * lanyards + 15 * packs_of_paper <= 116)
    model.addConstr(6 * lanyards + 4 * monochrome_printers + 15 * packs_of_paper <= 120)
    model.addConstr(6 * lanyards + 9 * mechanical_pencils + 9 * red_pens + 10 * blue_pens + 
                    4 * monochrome_printers + 15 * packs_of_paper + 7 * black_pens <= 120)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Lanyards: ", lanyards.varValue)
        print("Mechanical Pencils: ", mechanical_pencils.varValue)
        print("Red Pens: ", red_pens.varValue)
        print("Blue Pens: ", blue_pens.varValue)
        print("Monochrome Printers: ", monochrome_printers.varValue)
        print("Packs of Paper: ", packs_of_paper.varValue)
        print("Black Pens: ", black_pens.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
