
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
lanyards = m.addVar(vtype=gp.GRB.INTEGER, name="lanyards")
scissors = m.addVar(vtype=gp.GRB.INTEGER, name="scissors")
red_highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
manila_envelopes = m.addVar(vtype=gp.GRB.INTEGER, name="manila_envelopes")

# Set objective function
m.setObjective(5.87 * lanyards + 8.98 * scissors + 1.13 * red_highlighters + 9.47 * manila_envelopes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * lanyards + 30 * scissors + 27 * red_highlighters + 24 * manila_envelopes <= 782, "storage_space")
m.addConstr(24 * lanyards + 28 * scissors + 10 * red_highlighters + 4 * manila_envelopes <= 401, "workplace_safety_impact")
m.addConstr(25 * lanyards + 10 * scissors + 7 * red_highlighters + 21 * manila_envelopes <= 315, "dollar_cost")

m.addConstr(27 * red_highlighters + 24 * manila_envelopes >= 81, "storage_rh_me")
m.addConstr(4 * lanyards + 27 * red_highlighters >= 94, "storage_l_rh")
m.addConstr(30 * scissors + 24 * manila_envelopes >= 141, "storage_s_me")
m.addConstr(4 * lanyards + 27 * red_highlighters + 24 * manila_envelopes >= 192, "storage_l_rh_me")
m.addConstr(30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 192, "storage_s_rh_me")
m.addConstr(4 * lanyards + 27 * red_highlighters + 24 * manila_envelopes >= 155, "storage_l_rh_me_2")
m.addConstr(30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 155, "storage_s_rh_me_2")
m.addConstr(4 * lanyards + 30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 155, "storage_all")


m.addConstr(10 * red_highlighters + 4 * manila_envelopes >= 53, "safety_rh_me")
m.addConstr(28 * scissors + 10 * red_highlighters >= 40, "safety_s_rh")
m.addConstr(24 * lanyards + 10 * red_highlighters >= 37, "safety_l_rh")
m.addConstr(24 * lanyards + 4 * manila_envelopes >= 33, "safety_l_me")
m.addConstr(28 * scissors + 4 * manila_envelopes >= 87, "safety_s_me")
m.addConstr(24 * lanyards + 10 * red_highlighters + 4 * manila_envelopes >= 63, "safety_l_rh_me")
m.addConstr(24 * lanyards + 28 * scissors + 10 * red_highlighters + 4 * manila_envelopes >= 63, "safety_all")

m.addConstr(7 * red_highlighters + 21 * manila_envelopes >= 27, "cost_rh_me")
m.addConstr(25 * lanyards + 21 * manila_envelopes >= 53, "cost_l_me")
m.addConstr(25 * lanyards + 7 * red_highlighters >= 36, "cost_l_rh")
m.addConstr(10 * scissors + 7 * red_highlighters >= 39, "cost_s_rh")
m.addConstr(25 * lanyards + 10 * scissors >= 49, "cost_l_s")
m.addConstr(25 * lanyards + 10 * scissors + 7 * red_highlighters + 21 * manila_envelopes >= 49, "cost_all")

m.addConstr(6 * scissors - 9 * red_highlighters >= 0, "misc_1")
m.addConstr(-10 * red_highlighters + 5 * manila_envelopes >= 0, "misc_2")
m.addConstr(25 * lanyards + 10 * scissors + 21 * manila_envelopes <= 109, "cost_l_s_me")
m.addConstr(25 * lanyards + 7 * red_highlighters + 21 * manila_envelopes <= 151, "cost_l_rh_me_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

