
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
lanyards = m.addVar(name="lanyards", vtype=gp.GRB.INTEGER)
scissors = m.addVar(name="scissors", vtype=gp.GRB.INTEGER)
red_highlighters = m.addVar(name="red_highlighters", vtype=gp.GRB.INTEGER)
manila_envelopes = m.addVar(name="manila_envelopes", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5.87 * lanyards + 8.98 * scissors + 1.13 * red_highlighters + 9.47 * manila_envelopes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * lanyards + 30 * scissors + 27 * red_highlighters + 24 * manila_envelopes <= 782, "storage_space")
m.addConstr(24 * lanyards + 28 * scissors + 10 * red_highlighters + 4 * manila_envelopes <= 401, "workplace_safety_impact")
m.addConstr(25 * lanyards + 10 * scissors + 7 * red_highlighters + 21 * manila_envelopes <= 315, "dollar_cost")

m.addConstr(27 * red_highlighters + 24 * manila_envelopes >= 81, "red_highlighters_manila_envelopes_storage")
m.addConstr(4 * lanyards + 27 * red_highlighters >= 94, "lanyards_red_highlighters_storage")
m.addConstr(30 * scissors + 24 * manila_envelopes >= 141, "scissors_manila_envelopes_storage")
m.addConstr(4 * lanyards + 27 * red_highlighters + 24 * manila_envelopes >= 192, "total_storage_1")
m.addConstr(30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 192, "total_storage_2")
m.addConstr(4 * lanyards + 27 * red_highlighters + 24 * manila_envelopes >= 155, "total_storage_3")
m.addConstr(30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 155, "total_storage_4")
m.addConstr(4 * lanyards + 30 * scissors + 27 * red_highlighters + 24 * manila_envelopes >= 155, "total_storage_5")

m.addConstr(10 * red_highlighters + 4 * manila_envelopes >= 53, "red_highlighters_manila_envelopes_safety")
m.addConstr(28 * scissors + 10 * red_highlighters >= 40, "scissors_red_highlighters_safety")
m.addConstr(24 * lanyards + 10 * red_highlighters >= 37, "lanyards_red_highlighters_safety")
m.addConstr(24 * lanyards + 4 * manila_envelopes >= 33, "lanyards_manila_envelopes_safety")
m.addConstr(28 * scissors + 4 * manila_envelopes >= 87, "scissors_manila_envelopes_safety")
m.addConstr(24 * lanyards + 10 * red_highlighters + 4 * manila_envelopes >= 63, "total_safety_1")
m.addConstr(24 * lanyards + 28 * scissors + 10 * red_highlighters + 4 * manila_envelopes >= 63, "total_safety_2")

m.addConstr(7 * red_highlighters + 21 * manila_envelopes >= 27, "red_highlighters_manila_envelopes_cost")
m.addConstr(25 * lanyards + 21 * manila_envelopes >= 53, "lanyards_manila_envelopes_cost")
m.addConstr(25 * lanyards + 7 * red_highlighters >= 36, "lanyards_red_highlighters_cost")
m.addConstr(10 * scissors + 7 * red_highlighters >= 39, "scissors_red_highlighters_cost")
m.addConstr(25 * lanyards + 10 * scissors >= 49, "lanyards_scissors_cost")
m.addConstr(25 * lanyards + 10 * scissors + 7 * red_highlighters + 21 * manila_envelopes >= 49, "total_cost")

m.addConstr(6 * scissors - 9 * red_highlighters >= 0, "scissors_red_highlighters_constraint")
m.addConstr(-10 * red_highlighters + 5 * manila_envelopes >= 0, "red_highlighters_manila_envelopes_constraint")

m.addConstr(25 * lanyards + 10 * scissors + 21 * manila_envelopes <= 109, "lanyards_scissors_manila_envelopes_cost_limit")
m.addConstr(25 * lanyards + 7 * red_highlighters + 21 * manila_envelopes <= 151, "lanyards_red_highlighters_manila_envelopes_cost_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Lanyards: ", lanyards.varValue)
    print("Scissors: ", scissors.varValue)
    print("Red Highlighters: ", red_highlighters.varValue)
    print("Manila Envelopes: ", manila_envelopes.varValue)
else:
    print("No optimal solution found")
