
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(type=GRB.INTEGER, name="water_purification_units")
x1 = m.addVar(type=GRB.INTEGER, name="transportation_companies")

# Set objective function
m.setObjective(9*x0*x0 + 3*x0 + 8*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x0*x0 + 4*x1*x1 >= 25, "logistics_footprint_lower_bound")
m.addConstr(16*x0 + 18*x1 >= 25, "mobility_rating_lower_bound")
m.addConstr(-x0 + 8*x1 >= 0, "constraint_3")
m.addConstr(17*x0*x0 + 4*x1*x1 <= 93, "logistics_footprint_squared_upper_bound")
m.addConstr(17*x0 + 4*x1 <= 93, "logistics_footprint_upper_bound")
m.addConstr(16*x0 + 18*x1 <= 91, "mobility_rating_upper_bound_1")  # Redundant constraint
m.addConstr(16*x0 + 18*x1 <= 91, "mobility_rating_upper_bound_2")  # Redundant constraint
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

