
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables, x0 for water purification units and x1 for transportation companies
x0 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")
x1 = m.addVar(vtype=GRB.INTEGER, name="transportation_companies")

# Objective function: Maximize 9*x0^2 + 3*x0 + 8*x1
m.setObjective(9*x0**2 + 3*x0 + 8*x1, GRB.MAXIMIZE)

# Constraints
# Minimum total logistics footprint squared
m.addConstr((17*x0)**2 + (4*x1)**2 >= 25, name="min_logistics_footprint_squared")

# Minimum combined mobility rating
m.addConstr(16*x0 + 18*x1 >= 25, name="min_mobility_rating")

# Constraint involving water purification units and transportation companies
m.addConstr(-x0 + 8*x1 >= 0, name="water_purification_vs_transportation")

# Maximum total logistics footprint squared
m.addConstr((17*x0)**2 + (4*x1)**2 <= 93, name="max_logistics_footprint_squared")

# Maximum total logistics footprint (seems redundant but included as per problem statement)
m.addConstr(17*x0 + 4*x1 <= 93, name="max_total_logistics_footprint")

# Maximum combined mobility rating
m.addConstr(16*x0 + 18*x1 <= 91, name="max_mobility_rating")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Water Purification Units: {x0.x}")
    print(f"Transportation Companies: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
