
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("optimization_problem")

# Define variables
water_purification_units = model.addVar(lb=0, vtype=GRB.INTEGER, name="water_purification_units")
transportation_companies = model.addVar(lb=0, vtype=GRB.INTEGER, name="transportation_companies")

# Objective function
model.setObjective(9 * water_purification_units**2 + 3 * water_purification_units + 8 * transportation_companies, GRB.MAXIMIZE)

# Constraints
model.addConstr(17 * water_purification_units + 4 * transportation_companies <= 120, name="logistics_footprint")
model.addConstr(16 * water_purification_units + 18 * transportation_companies >= 25, name="mobility_rating_min")
model.addConstr(-1 * water_purification_units + 8 * transportation_companies >= 0, name="linear_constraint")
model.addConstr((17 * water_purification_units)**2 + (4 * transportation_companies)**2 >= 25, name="total_logistics_footprint_squared_min")
model.addConstr((17 * water_purification_units)**2 + (4 * transportation_companies)**2 <= 93, name="total_logistics_footprint_squared_max")
model.addConstr(17 * water_purification_units + 4 * transportation_companies <= 120, name="logistics_footprint_max")
model.addConstr(16 * water_purification_units + 18 * transportation_companies <= 91, name="combined_mobility_rating_max")

# Solve the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Water Purification Units: {water_purification_units.varValue}")
    print(f"Transportation Companies: {transportation_companies.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
