
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
laura_hours = model.addVar(vtype=GRB.CONTINUOUS, name="laura_hours")
hank_hours = model.addVar(vtype=GRB.CONTINUOUS, name="hank_hours")
paul_hours = model.addVar(vtype=GRB.CONTINUOUS, name="paul_hours")
peggy_hours = model.addVar(vtype=GRB.CONTINUOUS, name="peggy_hours")

# Set objective function
model.setObjective(4.64 * laura_hours + 3.55 * hank_hours + 9.46 * paul_hours + 7.42 * peggy_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * hank_hours + 6 * peggy_hours <= 210, "c1")
model.addConstr(26 * paul_hours + 6 * peggy_hours <= 210, "c2")
model.addConstr(17 * laura_hours + 26 * paul_hours <= 142, "c3")
model.addConstr(17 * laura_hours + 6 * peggy_hours <= 232, "c4")
model.addConstr(17 * laura_hours + 5 * hank_hours + 26 * paul_hours + 6 * peggy_hours <= 232, "c5")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

