
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define the variables
L = m.addVar(lb=0, name="hours_worked_by_Laura")
H = m.addVar(lb=0, name="hours_worked_by_Hank")
P = m.addVar(lb=0, name="hours_worked_by_Paul")
G = m.addVar(lb=0, name="hours_worked_by_Peggy")

# Define the objective function
m.setObjective(4.64*L + 3.55*H + 9.46*P + 7.42*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*H + 6*G <= 210, name="Constraint_1")
m.addConstr(26*P + 6*G <= 210, name="Constraint_2")
m.addConstr(17*L + 26*P <= 142, name="Constraint_3")
m.addConstr(17*L + 6*G <= 232, name="Constraint_4")
m.addConstr(17*L + 5*H + 26*P + 6*G <= 250, name="Total_Competence_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {L.x}")
    print(f"Hours worked by Hank: {H.x}")
    print(f"Hours worked by Paul: {P.x}")
    print(f"Hours worked by Peggy: {G.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
