
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    L = model.addVar(lb=0, name="Laura_hours")  # hours worked by Laura
    H = model.addVar(lb=0, name="Hank_hours")  # hours worked by Hank
    P = model.addVar(lb=0, name="Paul_hours")  # hours worked by Paul
    G = model.addVar(lb=0, name="Peggy_hours")  # hours worked by Peggy

    # Define the objective function
    model.setObjective(4.64*L + 3.55*H + 9.46*P + 7.42*G, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5*H + 6*G <= 210, name="Hank_Peggy_constraint")
    model.addConstr(26*P + 6*G <= 210, name="Paul_Peggy_constraint")
    model.addConstr(17*L + 26*P <= 142, name="Laura_Paul_constraint")
    model.addConstr(17*L + 6*G <= 232, name="Laura_Peggy_constraint")
    model.addConstr(17*L + 5*H + 26*P + 6*G <= 232, name="Total_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Laura hours: ", L.varValue)
        print("Hank hours: ", H.varValue)
        print("Paul hours: ", P.varValue)
        print("Peggy hours: ", G.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
