
import gurobipy as gp

# Create a new model
m = gp.Model("office_optimization")

# Create variables
office_chairs = m.addVar(vtype=gp.GRB.INTEGER, name="office_chairs")
color_printers = m.addVar(vtype=gp.GRB.INTEGER, name="color_printers")

# Set objective function
m.setObjective(7.49 * office_chairs + 9.65 * color_printers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * office_chairs + 16 * color_printers <= 71, "storage_space_limit") #71
m.addConstr(8 * office_chairs + 21 * color_printers <= 60, "cost_limit") #60
m.addConstr(19 * office_chairs + 16 * color_printers >= 25, "storage_space_minimum")
m.addConstr(8 * office_chairs + 21 * color_printers >= 30, "cost_minimum")
m.addConstr(5 * office_chairs - 7 * color_printers >= 0, "chair_printer_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Office Chairs:', office_chairs.x)
    print('Color Printers:', color_printers.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

