
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables as integers
x0 = m.addVar(vtype=GRB.INTEGER, name="office_chairs")
x1 = m.addVar(vtype=GRB.INTEGER, name="color_printers")

# Set the objective function
m.setObjective(7.49 * x0 + 9.65 * x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * x0 + 16 * x1 <= 110, "storage_space_constraint")
m.addConstr(8 * x0 + 21 * x1 <= 79, "cost_constraint")
m.addConstr(19 * x0 + 16 * x1 >= 25, "minimum_storage_usage")
m.addConstr(8 * x0 + 21 * x1 >= 30, "minimum_cost")
m.addConstr(5 * x0 - 7 * x1 >= 0, "linear_constraint")

# Update the model
m.update()

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Quantity of office chairs: {x0.x}")
    print(f"Quantity of color printers: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
