
import gurobi as gp

# Create a new model
m = gp.Model("office_chairs_and_printers")

# Define the variables
office_chairs = m.addVar(name="office_chairs", vtype=gp.GRB.INTEGER)
color_printers = m.addVar(name="color_printers", vtype=gp.GRB.INTEGER)

# Objective function: Minimize 7.49 * office_chairs + 9.65 * color_printers
m.setObjective(7.49 * office_chairs + 9.65 * color_printers, gp.GRB.MINIMIZE)

# Constraints
m.addConstraint(19 * office_chairs + 16 * color_printers >= 25, name="min_storage")
m.addConstraint(19 * office_chairs + 16 * color_printers <= 71, name="max_storage")
m.addConstraint(8 * office_chairs + 21 * color_printers >= 30, name="min_cost")
m.addConstraint(8 * office_chairs + 21 * color_printers <= 60, name="max_cost")
m.addConstraint(5 * office_chairs - 7 * color_printers >= 0, name="balance")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Office Chairs: {office_chairs.varValue}")
    print(f"Color Printers: {color_printers.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
