
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Hour_Optimization")

# Create variables
bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Bill_Hours")
john_hours = model.addVar(vtype=gp.GRB.INTEGER, name="John_Hours")
mary_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Mary_Hours")
peggy_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Peggy_Hours")

# Set objective function
model.setObjective(3.85 * bill_hours + 5.18 * john_hours + 2.03 * mary_hours + 3.6 * peggy_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * bill_hours + 8 * mary_hours >= 33, "c1")
model.addConstr(3 * bill_hours + 8 * mary_hours + 22 * peggy_hours >= 82, "c2")
model.addConstr(3 * bill_hours + 17 * john_hours + 8 * mary_hours >= 82, "c3")
model.addConstr(3 * bill_hours + 8 * mary_hours + 22 * peggy_hours >= 53, "c4")
model.addConstr(3 * bill_hours + 17 * john_hours + 8 * mary_hours >= 53, "c5")

model.addConstr(22 * bill_hours + 13 * peggy_hours <= 186, "c6")
model.addConstr(15 * mary_hours + 13 * peggy_hours <= 217, "c7")
model.addConstr(22 * bill_hours + 15 * mary_hours <= 262, "c8")
model.addConstr(4 * john_hours + 13 * peggy_hours <= 162, "c9")
model.addConstr(4 * john_hours + 15 * mary_hours <= 255, "c10")
model.addConstr(4 * john_hours + 15 * mary_hours + 13 * peggy_hours <= 247, "c11")
model.addConstr(22 * bill_hours + 4 * john_hours + 15 * mary_hours <= 200, "c12")
model.addConstr(22 * bill_hours + 15 * mary_hours + 13 * peggy_hours <= 192, "c13")
model.addConstr(22 * bill_hours + 4 * john_hours + 15 * mary_hours + 13 * peggy_hours <= 192, "c14")

model.addConstr(8 * mary_hours + 22 * peggy_hours <= 254, "c15")
model.addConstr(17 * john_hours + 8 * mary_hours <= 209, "c16")
model.addConstr(17 * john_hours + 22 * peggy_hours <= 242, "c17")
model.addConstr(3 * bill_hours + 22 * peggy_hours <= 192, "c18")
model.addConstr(3 * bill_hours + 17 * john_hours + 22 * peggy_hours <= 329, "c19")
model.addConstr(17 * john_hours + 8 * mary_hours + 22 * peggy_hours <= 291, "c20")
model.addConstr(3 * bill_hours + 17 * john_hours + 8 * mary_hours + 22 * peggy_hours <= 291, "c21")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"John's hours: {john_hours.x}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Peggy's hours: {peggy_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

