
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
B = m.addVar(name="B", vtype=gp.GRB.INTEGER)  # hours worked by Bill
J = m.addVar(name="J", vtype=gp.GRB.INTEGER)  # hours worked by John
M = m.addVar(name="M")  # hours worked by Mary
P = m.addVar(name="P", vtype=gp.GRB.INTEGER)  # hours worked by Peggy

# Define the objective function
m.setObjective(3.85 * B + 5.18 * J + 2.03 * M + 3.6 * P, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(B >= 0)
m.addConstr(J >= 0)
m.addConstr(M >= 0)
m.addConstr(P >= 0)

m.addConstr(3 * B + 8 * M >= 33)
m.addConstr(3 * B + 8 * M + 22 * P >= 82)
m.addConstr(3 * B + 17 * J + 8 * M >= 82)
m.addConstr(3 * B + 8 * M + 22 * P >= 53)
m.addConstr(3 * B + 17 * J + 8 * M >= 53)

m.addConstr(22 * B + 13 * P <= 186)
m.addConstr(15 * M + 13 * P <= 217)
m.addConstr(22 * B + 15 * M <= 262)
m.addConstr(4 * J + 13 * P <= 162)
m.addConstr(4 * J + 15 * M <= 255)
m.addConstr(4 * J + 15 * M + 13 * P <= 247)
m.addConstr(22 * B + 4 * J + 15 * M <= 200)
m.addConstr(22 * B + 15 * M + 13 * P <= 192)
m.addConstr(22 * B + 4 * J + 15 * M + 13 * P <= 192)

m.addConstr(8 * M + 22 * P <= 254)
m.addConstr(17 * J + 8 * M <= 209)
m.addConstr(17 * J + 22 * P <= 242)
m.addConstr(3 * B + 22 * P <= 192)
m.addConstr(3 * B + 17 * J + 22 * P <= 329)
m.addConstr(17 * J + 8 * M + 22 * P <= 291)
m.addConstr(3 * B + 17 * J + 8 * M + 22 * P <= 291)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {B.varValue}")
    print(f"Hours worked by John: {J.varValue}")
    print(f"Hours worked by Mary: {M.varValue}")
    print(f"Hours worked by Peggy: {P.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
