
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Optimization")

# Create variables
peggy = model.addVar(vtype=GRB.INTEGER, name="Peggy")
paul = model.addVar(vtype=GRB.CONTINUOUS, name="Paul")
bill = model.addVar(vtype=GRB.CONTINUOUS, name="Bill")
ringo = model.addVar(vtype=GRB.CONTINUOUS, name="Ringo")
bobby = model.addVar(vtype=GRB.CONTINUOUS, name="Bobby")

# Set objective function
model.setObjective(1.81*peggy*peggy + 1.02*peggy*paul + 8.68*peggy*ringo + 2.04*peggy*bobby + 6.6*paul*paul + 2.06*bill*ringo + 8.48*bill*bobby + 3.68*ringo*bobby + 6.35*peggy + 9.93*ringo, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*ringo + 3*bobby >= 51)
model.addConstr(8*peggy + 12*bill + 3*bobby >= 50)
model.addConstr(7*bill + 5*ringo >= 38)
model.addConstr(10*paul + 5*ringo >= 48)
model.addConstr(2*peggy*peggy + 10*paul*paul >= 48)
model.addConstr(10*paul*paul + 2*bobby*bobby >= 41)
model.addConstr(9*paul*paul + 5*bill*bill + 12*bobby*bobby >= 25)
model.addConstr(9*paul + 5*bill + 5*ringo >= 25)
model.addConstr(2*peggy + 5*bill + 5*ringo >= 25)
model.addConstr(2*peggy + 9*paul + 5*ringo >= 25)
model.addConstr(9*paul*paul + 5*ringo*ringo + 12*bobby*bobby >= 25)
model.addConstr(2*peggy*peggy + 5*bill*bill + 12*bobby*bobby >= 25)
model.addConstr(9*paul + 5*bill + 12*bobby >= 19)
model.addConstr(9*paul + 5*bill + 5*ringo >= 19)
model.addConstr(2*peggy + 5*bill + 5*ringo >= 19)
model.addConstr(2*peggy + 9*paul + 5*ringo >= 19)
model.addConstr(9*paul + 5*ringo + 12*bobby >= 19)
model.addConstr(2*peggy + 5*bill + 12*bobby >= 19)
model.addConstr(9*paul + 5*bill + 12*bobby >= 22)
model.addConstr(9*paul + 5*bill + 5*ringo >= 22)
model.addConstr(2*peggy + 5*bill + 5*ringo >= 22)
model.addConstr(2*peggy + 9*paul + 5*ringo >= 22)
model.addConstr(9*paul*paul + 5*ringo*ringo + 12*bobby*bobby >= 22)
model.addConstr(2*peggy + 5*bill + 12*bobby >= 22)
model.addConstr(9*paul + 5*bill + 12*bobby >= 23)
model.addConstr(9*paul + 5*bill + 5*ringo >= 23)
model.addConstr(2*peggy*peggy + 5*bill*bill + 5*ringo*ringo >= 23)
model.addConstr(2*peggy + 9*paul + 5*ringo >= 23)
model.addConstr(9*paul + 5*ringo + 12*bobby >= 23)
model.addConstr(2*peggy + 5*bill + 12*bobby >= 23)
model.addConstr(9*paul*paul + 5*bill*bill + 12*bobby*bobby >= 22)
model.addConstr(9*paul + 5*bill + 5*ringo >= 22)
model.addConstr(2*peggy + 5*bill + 5*ringo >= 22)
model.addConstr(2*peggy + 9*paul + 5*ringo >= 22)
model.addConstr(9*paul + 5*ringo + 12*bobby >= 22)
model.addConstr(2*peggy*peggy + 5*bill*bill + 12*bobby*bobby >= 22)
model.addConstr(9*paul + 5*bill + 12*bobby >= 22)
model.addConstr(9*paul + 5*bill + 5*ringo >= 22)
model.addConstr(2*peggy + 5*bill + 5*ringo >= 22)
model.addConstr(2*peggy*peggy + 9*paul*paul + 5*ringo*ringo >= 22)
model.addConstr(9*paul + 5*ringo + 12*bobby >= 22)
model.addConstr(2*peggy*peggy + 5*bill*bill + 12*bobby*bobby >= 22)


model.addConstr(14*paul*paul + 5*ringo*ringo >= 48)
model.addConstr(6*peggy + 5*ringo >= 26)
model.addConstr(6*peggy + 14*paul >= 65)
model.addConstr(6*peggy + 9*bill >= 54)
model.addConstr(5*ringo + 2*bobby >= 33)
model.addConstr(6*peggy*peggy + 14*paul*paul + 5*ringo*ringo >= 52)
model.addConstr(-4*paul + 8*bill + 10*ringo >= 0)

#Resource Upper Bound Constraints
model.addConstr(8*peggy + 3*bobby <= 154)
model.addConstr(5*ringo + 3*bobby <= 180)
model.addConstr(12*bill*bill + 3*bobby*bobby <= 184)
model.addConstr(4*paul + 12*bill + 5*ringo <= 85)
model.addConstr(12*bill + 5*ringo + 3*bobby <= 317)
model.addConstr(8*peggy + 12*bill + 3*bobby <= 156)
model.addConstr(4*paul*paul + 12*bill*bill + 3*bobby*bobby <= 106)
model.addConstr(8*peggy*peggy + 4*paul*paul + 3*bobby*bobby <= 281)
model.addConstr(8*peggy + 4*paul + 12*bill + 5*ringo + 3*bobby <= 281)

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
