
import gurobi as gp

m = gp.Model()

P = m.addVar(name="P", vtype=gp.GRB.INTEGER)
L = m.addVar(name="L")
B = m.addVar(name="B")
R = m.addVar(name="R")
O = m.addVar(name="O")

m.setObjective(1.81 * P ** 2 + 1.02 * P * L + 8.68 * P * R + 2.04 * P * O + 
               6.6 * L ** 2 + 2.06 * B * R + 8.48 * B * O + 3.68 * R * O + 
               6.35 * P + 9.93 * R, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(8 * P == 8)
m.addConstr(2 * P == 2)
m.addConstr(2 * P == 2)
m.addConstr(6 * P == 6)

m.addConstr(4 * L == 4)
m.addConstr(10 * L == 10)
m.addConstr(9 * L == 9)
m.addConstr(14 * L == 14)

m.addConstr(12 * B == 12)
m.addConstr(7 * B == 7)
m.addConstr(5 * B == 5)
m.addConstr(9 * B == 9)

m.addConstr(5 * R == 5)
m.addConstr(5 * R == 5)
m.addConstr(5 * R == 5)
m.addConstr(5 * R == 5)

m.addConstr(3 * O == 3)
m.addConstr(2 * O == 2)
m.addConstr(12 * O == 12)
m.addConstr(2 * O == 2)

m.addConstr(5 * R + 3 * O >= 51)
m.addConstr(8 * P + 12 * B + 3 * O >= 50)

try:
    m.optimize()
    if m.status == gp.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("P: ", P.varValue)
        print("L: ", L.varValue)
        print("B: ", B.varValue)
        print("R: ", R.varValue)
        print("O: ", O.varValue)
    else:
        print("No solution found")
except gp.GurobiError as e:
    print("Error: ", e)
