
from gurobipy import Model, GRB

# Create a new model
model = Model("work_hours_optimization")

# Create variables
dale_hours = model.addVar(name="dale_hours", lb=0)
bobby_hours = model.addVar(name="bobby_hours", lb=0)
jean_hours = model.addVar(name="jean_hours", lb=0)

# Set objective function
model.setObjective(
    7.88 * dale_hours * dale_hours
    + 3.37 * dale_hours * jean_hours
    + 5.46 * bobby_hours * jean_hours
    + 4.27 * jean_hours * jean_hours
    + 7.6 * dale_hours
    + 3.89 * bobby_hours
    + 7.16 * jean_hours,
    GRB.MAXIMIZE,
)

# Add constraints
model.addConstr(18 * dale_hours + 22 * bobby_hours >= 51, "paperwork_competence_1")
model.addConstr(18 * dale_hours * dale_hours + 9 * jean_hours * jean_hours >= 38, "paperwork_competence_2")
model.addConstr(12 * dale_hours + 27 * bobby_hours >= 20, "likelihood_to_quit_1")
model.addConstr(18 * dale_hours + 22 * bobby_hours <= 236, "paperwork_competence_3")
model.addConstr(18 * dale_hours + 22 * bobby_hours + 9 * jean_hours <= 236, "paperwork_competence_4")
model.addConstr(12 * dale_hours + 27 * bobby_hours <= 135, "likelihood_to_quit_2")
model.addConstr(27 * bobby_hours + 13 * jean_hours <= 144, "likelihood_to_quit_3")
model.addConstr(12 * dale_hours + 27 * bobby_hours + 13 * jean_hours <= 144, "likelihood_to_quit_4")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Dale's hours: {dale_hours.x}")
    print(f"Bobby's hours: {bobby_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Optimal objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

