
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x_D = m.addVar(name="hours_worked_by_Dale", lb=0)
x_B = m.addVar(name="hours_worked_by_Bobby", lb=0)
x_J = m.addVar(name="hours_worked_by_Jean", lb=0)

# Define the objective function
m.setObjective(7.88*x_D**2 + 3.37*x_D*x_J + 5.46*x_B*x_J + 4.27*x_J**2 + 7.6*x_D + 3.89*x_B + 7.16*x_J, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18*x_D <= 261, name="Dale_paperwork")
m.addConstr(12*x_D <= 159, name="Dale_quit")
m.addConstr(22*x_B <= 261, name="Bobby_paperwork")
m.addConstr(27*x_B <= 159, name="Bobby_quit")
m.addConstr(9*x_J <= 261, name="Jean_paperwork")
m.addConstr(13*x_J <= 159, name="Jean_quit")

m.addConstr(18*x_D + 22*x_B >= 51, name="combined_paperwork_min")
m.addConstr(22**2*x_B**2 + 9**2*x_J**2 >= 38, name="combined_paperwork_min_squared")
m.addConstr(12*x_D + 27*x_B >= 20, name="combined_quit_min")
m.addConstr(18*x_D + 22*x_B <= 236, name="combined_paperwork_max")
m.addConstr(18*x_D + 22*x_B + 9*x_J <= 236, name="combined_paperwork_max_jean")
m.addConstr(12*x_D + 27*x_B <= 135, name="combined_quit_max")
m.addConstr(27*x_B + 13*x_J <= 144, name="combined_quit_max_jean")
m.addConstr(12*x_D + 27*x_B + 13*x_J <= 144, name="combined_quit_max_all")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x_D.varValue}")
    print(f"Hours worked by Bobby: {x_B.varValue}")
    print(f"Hours worked by Jean: {x_J.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
