
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
b3 = m.addVar(lb=0, name="B3")  # milligrams of vitamin B3
e = m.addVar(lb=0, name="E")  # milligrams of vitamin E
b7 = m.addVar(lb=0, name="B7")  # milligrams of vitamin B7
b9 = m.addVar(lb=0, name="B9")  # milligrams of vitamin B9

# Set objective function
obj = 7 * b3**2 + 5 * b3 * e + 8 * b3 * b7 + 3 * e**2 + 2 * e * b7 + 8 * e * b9 + 7 * b7 * b9 + 4 * b9**2 + 6 * b3 + 3 * e + 2 * b9
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * b3 + 5 * b9 >= 16, "c1")
m.addConstr(7 * e + 5 * b9 >= 11, "c2")
m.addConstr(7 * e + 3 * b7 + 5 * b9 >= 22, "c3")
m.addConstr(7 * e + 6 * b9 >= 7, "c4")
m.addConstr(3 * b3 + 8 * b7 >= 12, "c5")
m.addConstr(8 * b7 + 6 * b9 >= 10, "c6")
m.addConstr(3 * b3**2 + 7 * e**2 + 8 * b7**2 >= 10, "c7")
m.addConstr(3 * b3**2 + 7 * e**2 + 6 * b9**2 >= 10, "c8")
m.addConstr(3 * b3 + 7 * e + 8 * b7 >= 9, "c9")
m.addConstr(3 * b3 + 7 * e + 6 * b9 >= 9, "c10")
m.addConstr(6 * b3 + 3 * b9 >= 11, "c11")
m.addConstr(6 * e + 3 * b9 >= 10, "c12")
m.addConstr(6 * e + 6 * b7 >= 14, "c13")
m.addConstr(6 * b3 + 6 * e + 3 * b9 >= 21, "c14")
m.addConstr(-10 * b3**2 - 5 * b7**2 + 8 * b9**2 >= 0, "c15")
m.addConstr(8 * b3**2 + 7 * e**2 <= 110, "c16")
m.addConstr(7 * e + 3 * b7 <= 82, "c17")
m.addConstr(8 * b3**2 + 3 * b7**2 <= 65, "c18")
m.addConstr(8 * b3**2 + 7 * e**2 + 5 * b9**2 <= 64, "c19")
m.addConstr(8 * b3 + 7 * e + 3 * b7 + 5 * b9 <= 64, "c20")
m.addConstr(7 * e + 6 * b9 <= 41, "c21")
m.addConstr(3 * b3 + 7 * e <= 54, "c22")
m.addConstr(3 * b3 + 6 * b9 <= 70, "c23")
m.addConstr(3 * b3 + 7 * e + 8 * b7 + 6 * b9 <= 70, "c24")
m.addConstr(6 * b3 + 6 * b7 <= 66, "c25")
m.addConstr(6 * e**2 + 3 * b9**2 <= 35, "c26")
m.addConstr(6 * e + 6 * b7 <= 52, "c27")
m.addConstr(6 * b3 + 6 * e + 6 * b7 + 3 * b9 <= 52, "c28")
m.addConstr(3 * e + 1 * b7 <= 17, "c29")
m.addConstr(2 * b3**2 + 3 * b9**2 <= 17, "c30")
m.addConstr(2 * b3 + 1 * b7 <= 22, "c31")
m.addConstr(1 * b7 + 3 * b9 <= 26, "c32")
m.addConstr(3 * e + 1 * b7 + 3 * b9 <= 28, "c33")
m.addConstr(2 * b3 + 3 * e + 3 * b9 <= 21, "c34")
m.addConstr(2 * b3 + 1 * b7 + 3 * b9 <= 37, "c35")
m.addConstr(2 * b3 + 3 * e + 1 * b7 + 3 * b9 <= 37, "c36")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Optimization failed. Status code:", m.status)

