
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="bowls_of_pasta", vtype=GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="black_beans", vtype=GRB.CONTINUOUS)

# Objective function: Maximize 3*x0 + 8*x1
m.setObjective(3*x0 + 8*x1, GRB.MAXIMIZE)

# Constraints
# Umami index constraint (lower bound)
m.addConstr(5*x0 + 16*x1 >= 12, name="umami_index_lower_bound")

# Iron milligrams constraint (lower bound)
m.addConstr(8*x0 + 12*x1 >= 11, name="iron_milligrams_lower_bound")

# Constraint involving negative bowls of pasta and positive black beans
m.addConstr(-4*x0 + 10*x1 >= 0, name="negative_bowls_positive_beans")

# Upper bounds on umami index and iron milligrams
m.addConstr(5*x0 + 16*x1 <= 57, name="umami_index_upper_bound")
m.addConstr(8*x0 + 12*x1 <= 27, name="iron_milligrams_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"bowls_of_pasta = {x0.x}")
    print(f"black_beans = {x1.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
