
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    bowls_of_pasta = model.addVar(name="bowls_of_pasta", lb=0)  # Can be fractional
    black_beans = model.addVar(name="black_beans", lb=0)  # Can be fractional

    # Define the objective function
    model.setObjective(3 * bowls_of_pasta + 8 * black_beans, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Umami index from resources
    umami_index_bowls_of_pasta = 5 * bowls_of_pasta
    umami_index_black_beans = 16 * black_beans

    # Milligrams of iron from resources
    iron_index_bowls_of_pasta = 8 * bowls_of_pasta
    iron_index_black_beans = 12 * black_beans

    # The total combined umami index must be as much or more than 12
    model.addConstraint(umami_index_bowls_of_pasta + umami_index_black_beans >= 12, name="umami_min")

    # You must get at least 11 milligrams of iron
    model.addConstraint(iron_index_bowls_of_pasta + iron_index_black_beans >= 11, name="iron_min")

    # -4 times the number of bowls of pasta, plus 10 times the number of black beans should be at minimum zero
    model.addConstraint(-4 * bowls_of_pasta + 10 * black_beans >= 0, name="pasta_bean_balance")

    # The total combined umami index has to be equal to or less than 57
    model.addConstraint(umami_index_bowls_of_pasta + umami_index_black_beans <= 57, name="umami_max")

    # You must get no more than 27 milligrams of iron
    model.addConstraint(iron_index_bowls_of_pasta + iron_index_black_beans <= 27, name="iron_max")

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Bowls of pasta: {bowls_of_pasta.varValue}")
        print(f"Black beans: {black_beans.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
