
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")

# Set objective function
m.setObjective(5 * lemons + 3 * eggs + 4 * bagged_salads + 6 * tomatoes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * lemons + 13 * tomatoes >= 19, "c1")
m.addConstr(4 * eggs + 13 * tomatoes >= 33, "c2")
m.addConstr(11 * lemons + 5 * eggs + 4 * tomatoes >= 37, "c3")
m.addConstr(2 * lemons + 12 * tomatoes >= 24, "c4")
m.addConstr(2 * lemons + 8 * eggs >= 34, "c5")
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads >= 27, "c6")
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes >= 27, "c7")
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes >= 27, "c8")
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads >= 35, "c9")
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes >= 35, "c10")
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes >= 35, "c11")
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads >= 31, "c12")
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes >= 31, "c13")
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes >= 31, "c14")
m.addConstr(4 * eggs + 13 * tomatoes <= 86, "c15")
m.addConstr(14 * lemons + 4 * eggs + 15 * bagged_salads <= 75, "c16")
m.addConstr(14 * lemons + 4 * eggs + 15 * bagged_salads + 13 * tomatoes <= 75, "c17")
m.addConstr(11 * lemons + 5 * bagged_salads <= 100, "c18")
m.addConstr(5 * eggs + 4 * tomatoes <= 85, "c19")
m.addConstr(5 * bagged_salads + 4 * tomatoes <= 104, "c20")
m.addConstr(5 * eggs + 5 * bagged_salads <= 47, "c21")
m.addConstr(11 * lemons + 5 * eggs + 5 * bagged_salads + 4 * tomatoes <= 47, "c22")
m.addConstr(15 * bagged_salads + 12 * tomatoes <= 81, "c23")
m.addConstr(2 * lemons + 12 * tomatoes <= 102, "c24")
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes <= 142, "c25")
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes <= 147, "c26")
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads + 12 * tomatoes <= 147, "c27")


# Resource constraints (given in the problem description)
m.addConstr(14 * lemons + 4 * eggs + 15 * bagged_salads + 13 * tomatoes <= 135, "sourness_index")
m.addConstr(11 * lemons + 5 * eggs + 5 * bagged_salads + 4 * tomatoes <= 156, "grams_of_fat")
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads + 12 * tomatoes <= 156, "milligrams_of_iron")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

