
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
lemons = m.addVar(lb=-gp.GRB.INFINITY, name="lemons")
eggs = m.addVar(lb=-gp.GRB.INFINITY, name="eggs")
bagged_salads = m.addVar(lb=-gp.GRB.INFINITY, name="bagged_salads")
tomatoes = m.addVar(lb=-gp.GRB.INFINITY, name="tomatoes")

# Define the objective function
m.setObjective(5 * lemons + 3 * eggs + 4 * bagged_salads + 6 * tomatoes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * lemons <= 135)
m.addConstr(11 * lemons <= 156)
m.addConstr(2 * lemons <= 156)
m.addConstr(4 * eggs <= 135)
m.addConstr(5 * eggs <= 156)
m.addConstr(8 * eggs <= 156)
m.addConstr(15 * bagged_salads <= 135)
m.addConstr(5 * bagged_salads <= 156)
m.addConstr(15 * bagged_salads <= 156)
m.addConstr(13 * tomatoes <= 135)
m.addConstr(4 * tomatoes <= 156)
m.addConstr(12 * tomatoes <= 156)

m.addConstr(14 * lemons + 13 * tomatoes >= 19)
m.addConstr(4 * eggs + 13 * tomatoes >= 33)
m.addConstr(11 * lemons + 5 * eggs + 4 * tomatoes >= 37)
m.addConstr(2 * lemons + 12 * tomatoes >= 24)
m.addConstr(2 * lemons + 8 * eggs >= 34)
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads >= 27)
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes >= 27)
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes >= 27)
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads >= 35)
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes >= 35)
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes >= 35)
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads >= 31)
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes >= 31)
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes >= 31)

m.addConstr(4 * eggs + 13 * tomatoes <= 86)
m.addConstr(14 * lemons + 4 * eggs + 15 * bagged_salads <= 75)
m.addConstr(14 * lemons + 4 * eggs + 15 * bagged_salads + 13 * tomatoes <= 75)

m.addConstr(11 * lemons + 5 * bagged_salads <= 100)
m.addConstr(5 * eggs + 4 * tomatoes <= 85)
m.addConstr(5 * bagged_salads + 4 * tomatoes <= 104)
m.addConstr(5 * eggs + 5 * bagged_salads <= 47)
m.addConstr(11 * lemons + 5 * eggs + 5 * bagged_salads + 4 * tomatoes <= 47)

m.addConstr(15 * bagged_salads + 12 * tomatoes <= 81)
m.addConstr(2 * lemons + 12 * tomatoes <= 102)
m.addConstr(8 * eggs + 15 * bagged_salads + 12 * tomatoes <= 142)
m.addConstr(2 * lemons + 8 * eggs + 12 * tomatoes <= 147)
m.addConstr(2 * lemons + 8 * eggs + 15 * bagged_salads + 12 * tomatoes <= 147)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Lemons: ", lemons.varValue)
    print("Eggs: ", eggs.varValue)
    print("Bagged Salads: ", bagged_salads.varValue)
    print("Tomatoes: ", tomatoes.varValue)
else:
    print("The model is infeasible")
