
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_optimization")

# Create variables
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")

# Set objective function
m.setObjective(7.19 * patches_per_day * pen_testers + 1.57 * patches_per_day * intrusion_analysts + 2.02 * pen_testers**2 + 3.09 * patches_per_day + 7.49 * pen_testers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11.44 * patches_per_day + 11.11 * pen_testers + 14.9 * intrusion_analysts <= 84, "Power Consumption") #r0
m.addConstr(12.65 * patches_per_day + 0.78 * pen_testers + 14.19 * intrusion_analysts <= 155, "Data Integrity Impact") #r1

m.addConstr(11.44 * patches_per_day + 14.9 * intrusion_analysts <= 65, "Patches and Analysts Power")
m.addConstr(12.65 * patches_per_day + 14.19 * intrusion_analysts <= 69, "Patches and Analysts Data Integrity")

m.addConstr(0.78 * pen_testers + 14.19 * intrusion_analysts <= 105, "Testers and Analysts Data Integrity")
m.addConstr(12.65 * patches_per_day + 0.78 * pen_testers <= 107, "Patches and Testers Data Integrity")
m.addConstr(12.65 * patches_per_day + 0.78 * pen_testers + 14.19 * intrusion_analysts <= 131, "Total Data Integrity Impact")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('patches_per_day:', patches_per_day.x)
    print('pen_testers:', pen_testers.x)
    print('intrusion_analysts:', intrusion_analysts.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

