
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")  # Patches per day
x1 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")      # Pen testers
x2 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts") # Intrusion analysts

# Objective function: Maximize
m.setObjective(7.19*x0*x1 + 1.57*x0*x2 + 2.02*x1**2 + 3.09*x0 + 7.49*x1, GRB.MAXIMIZE)

# Constraints
# Power consumption constraints
m.addConstr(11.44*x0 + 11.11*x1 + 14.9*x2 <= 65, name="total_power_consumption")
m.addConstr(11.44*x0 + 14.9*x2 <= 65, name="patches_and_intrusion_power")

# Data integrity impact constraints
m.addConstr(12.65*x0 + 0.78*x1 + 14.19*x2 <= 131, name="total_data_integrity")
m.addConstr(12.65*x0 + 14.19*x2 <= 69, name="patches_and_intrusion_data_integrity")
m.addConstr(0.78*x1 + 14.19*x2 <= 105, name="pen_testers_and_intrusion_data_integrity")
m.addConstr(12.65*x0 + 0.78*x1 <= 107, name="patches_and_pen_testers_data_integrity")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
