
import gurobipy as gp

# Create a new model
m = gp.Model("Organization Score Optimization")

# Create variables
peggy_hours = m.addVar(lb=0, name="peggy_hours")
paul_hours = m.addVar(lb=0, name="paul_hours")
bill_hours = m.addVar(lb=0, name="bill_hours")

# Set objective function
m.setObjective(8.96 * peggy_hours + 1.78 * paul_hours + 9.49 * bill_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * peggy_hours + 17 * paul_hours >= 38, "c1")
m.addConstr(20 * peggy_hours + 4 * bill_hours >= 35, "c2")
m.addConstr(17 * paul_hours + 4 * bill_hours >= 50, "c3")
m.addConstr(20 * peggy_hours + 17 * paul_hours + 4 * bill_hours >= 83, "c4")
m.addConstr(17 * paul_hours + 4 * bill_hours <= 198, "c5")
m.addConstr(20 * peggy_hours + 17 * paul_hours <= 166, "c6")
m.addConstr(20 * peggy_hours + 17 * paul_hours + 4 * bill_hours <= 166, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Peggy hours:', peggy_hours.x)
    print('Paul hours:', paul_hours.x)
    print('Bill hours:', bill_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

