
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(8.96*x0 + 1.78*x1 + 9.49*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x0 + 17*x1 >= 38, name="Constraint_1")
m.addConstr(20*x0 + 4*x2 >= 35, name="Constraint_2")
m.addConstr(17*x1 + 4*x2 >= 50, name="Constraint_3")
m.addConstr(20*x0 + 17*x1 + 4*x2 >= 83, name="Constraint_4")
m.addConstr(17*x1 + 4*x2 <= 198, name="Constraint_5")
m.addConstr(20*x0 + 17*x1 <= 166, name="Constraint_6")
m.addConstr(20*x0 + 17*x1 + 4*x2 <= 166, name="Constraint_7")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Peggy: {x0.x}")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
