
import gurobi as gp

# Create a new model
m = gp.Model("organization_score_optimization")

# Define variables
peggy_hours = m.addVar(name="peggy_hours", lb=0)  # hours worked by Peggy
paul_hours = m.addVar(name="paul_hours", lb=0)   # hours worked by Paul
bill_hours = m.addVar(name="bill_hours", lb=0)   # hours worked by Bill

# Objective function coefficients
obj_coef_peggy = 8.96
obj_coef_paul = 1.78
obj_coef_bill = 9.49

# Set objective function
m.setObjective(obj_coef_peggy * peggy_hours + obj_coef_paul * paul_hours + obj_coef_bill * bill_hours, gp.GRB.MAXIMIZE)

# Constraints
peggy_score = 20
paul_score = 17
bill_score = 4

# Peggy + Paul >= 38
m.addConstraint(peggy_score * peggy_hours + paul_score * paul_hours >= 38, name="peggy_paul_score")

# Peggy + Bill >= 35
m.addConstraint(peggy_score * peggy_hours + bill_score * bill_hours >= 35, name="peggy_bill_score")

# Paul + Bill >= 50
m.addConstraint(paul_score * paul_hours + bill_score * bill_hours >= 50, name="paul_bill_score")

# Peggy + Paul + Bill >= 83
m.addConstraint(peggy_score * peggy_hours + paul_score * paul_hours + bill_score * bill_hours >= 83, name="total_score")

# Paul + Bill <= 198
m.addConstraint(paul_score * paul_hours + bill_score * bill_hours <= 198, name="paul_bill_score_upper")

# Peggy + Paul <= 166
m.addConstraint(peggy_score * peggy_hours + paul_score * paul_hours <= 166, name="peggy_paul_score_upper")

# Peggy + Paul + Bill <= 166
m.addConstraint(peggy_score * peggy_hours + paul_score * paul_hours + bill_score * bill_hours <= 166, name="total_score_upper")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Peggy hours: {peggy_hours.varValue}")
    print(f"Paul hours: {paul_hours.varValue}")
    print(f"Bill hours: {bill_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
