
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
mary = m.addVar(name="mary")
dale = m.addVar(name="dale")
john = m.addVar(name="john")
paul = m.addVar(name="paul")
george = m.addVar(name="george")
laura = m.addVar(name="laura")
peggy = m.addVar(name="peggy")

# Set objective function
m.setObjective(4.29 * mary + 6.96 * dale + 1.97 * john + 6.01 * paul + 8.03 * george + 8.83 * laura + 3.7 * peggy, GRB.MAXIMIZE)

# Add constraints
m.addConstr(23 * john + 15 * paul + 8 * laura >= 49)
m.addConstr(10 * john + 18 * george + 6 * laura >= 91)
m.addConstr(10 * john + 6 * laura + 23 * peggy >= 91)
m.addConstr(1 * paul + 6 * laura + 23 * peggy >= 91)
m.addConstr(15 * mary + 10 * john + 18 * george >= 91)
m.addConstr(11 * dale + 18 * george + 23 * peggy >= 91)
m.addConstr(1 * paul + 18 * george + 6 * laura >= 91)
m.addConstr(10 * john + 1 * paul + 6 * laura >= 91)
m.addConstr(15 * mary + 18 * george + 6 * laura >= 91)
m.addConstr(11 * dale + 1 * paul + 6 * laura >= 91)
m.addConstr(11 * dale + 10 * john + 23 * peggy >= 91)
m.addConstr(18 * george + 6 * laura + 23 * peggy >= 91)
m.addConstr(15 * mary + 10 * john + 1 * paul >= 91)
m.addConstr(11 * dale + 18 * george + 6 * laura >= 91)
m.addConstr(15 * mary + 11 * dale + 6 * laura >= 91)
m.addConstr(15 * mary + 11 * dale + 1 * paul >= 91)
m.addConstr(11 * dale + 10 * john + 6 * laura >= 91)
m.addConstr(15 * mary + 18 * george + 23 * peggy >= 91)
m.addConstr(15 * mary + 11 * dale + 23 * peggy >= 91)

# ... (Similarly add the remaining constraints for 75, 83, 84, 93, 97, 99, 115, 119, 122, 123, 125, 137, 140, 143, 146)
# Example for 75:
m.addConstr(10 * john + 18 * george + 6 * laura >= 75)
# ... (Add other constraints in a similar manner)


m.addConstr(23 * john + 20 * george <= 455)
m.addConstr(3 * mary + 8 * laura <= 364)
m.addConstr(19 * dale + 8 * laura <= 244)
m.addConstr(23 * john + 15 * paul <= 112)
m.addConstr(23 * john + 8 * laura <= 482)
m.addConstr(3 * mary + 19 * dale <= 414)
m.addConstr(3 * mary + 20 * george <= 513)
m.addConstr(8 * laura + 1 * peggy <= 245)
m.addConstr(19 * dale + 23 * john <= 496)
m.addConstr(23 * john + 1 * peggy <= 429)
m.addConstr(15 * paul + 1 * peggy <= 86)
m.addConstr(3 * mary + 1 * peggy <= 176)
m.addConstr(23 * john + 20 * george + 8 * laura <= 478)
m.addConstr(19 * dale + 23 * john + 15 * paul <= 197)
m.addConstr(3 * mary + 19 * dale + 23 * john + 15 * paul + 20 * george + 8 * laura + 1 * peggy <= 197)

m.addConstr(18 * george + 6 * laura <= 977)
m.addConstr(11 * dale + 23 * peggy <= 478)
m.addConstr(15 * mary + 1 * paul <= 186)
m.addConstr(10 * john + 6 * laura <= 733)
m.addConstr(15 * mary + 18 * george <= 394)
m.addConstr(10 * john + 23 * peggy <= 835)
m.addConstr(15 * mary + 6 * laura <= 983)
m.addConstr(15 * mary + 11 * dale <= 787)
m.addConstr(11 * dale + 10 * john <= 640)
m.addConstr(15 * mary + 11 * dale + 10 * john + 1 * paul + 18 * george + 6 * laura + 23 * peggy <= 640)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
