
from gurobi import *

# Define the model
m = Model("Employee_Hours")

# Define the variables (hours worked by each employee)
Mary = m.addVar(name="Mary", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
Dale = m.addVar(name="Dale", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
John = m.addVar(name="John", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
Paul = m.addVar(name="Paul", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
George = m.addVar(name="George", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
Laura = m.addVar(name="Laura", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
Peggy = m.addVar(name="Peggy", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)

# Add constraints for productivity ratings
m.addConstr(Mary + Dale >= 122, name="Mary_Dale_Productivity")
m.addConstr(John + Paul >= 137, name="John_Paul_Productivity")
m.addConstr(George + Laura >= 119, name="George_Laura_Productivity")
m.addConstr(Peggy + Mary >= 122, name="Peggy_Mary_Productivity")

# Add constraints for dollar cost per hour
m.addConstr(John * 20 + George * 25 <= 455, name="John_George_Cost")
m.addConstr(Mary * 15 + Laura * 22 <= 364, name="Mary_Laura_Cost")
m.addConstr(Dale * 18 + Laura * 10 <= 244, name="Dale_Laura_Cost")

# Add constraints for maximum productivity ratings
m.addConstr(George + Laura <= 977, name="George_Laura_Max_Productivity")
m.addConstr(Dale + Peggy <= 478, name="Dale_Peggy_Max_Productivity")
m.addConstr(Mary + Paul <= 186, name="Mary_Paul_Max_Productivity")

# Add constraints for maximum dollar cost per hour
m.addConstr(John * 20 + George * 25 + Laura * 10 <= 478, name="John_George_Laura_Cost")
m.addConstr(Mary * 15 + Dale * 18 + John * 20 + Paul * 12 + George * 25 + Laura * 10 + Peggy * 14 <= 197, name="All_Employees_Cost")

# Set the objective function to maximize productivity
m.setObjective(Mary + Dale + John + Paul + George + Laura + Peggy, GRB.MAXIMIZE)

# Optimize the model
m.optimize()
