
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
M = m.addVar(lb=0, ub=None, name="M", vtype=gurobi.GRB.CONTINUOUS)
D = m.addVar(lb=0, ub=None, name="D", vtype=gurobi.GRB.CONTINUOUS)
J = m.addVar(lb=0, ub=None, name="J", vtype=gurobi.GRB.CONTINUOUS)
P = m.addVar(lb=0, ub=None, name="P", vtype=gurobi.GRB.CONTINUOUS)
G = m.addVar(lb=0, ub=None, name="G", vtype=gurobi.GRB.CONTINUOUS)
L = m.addVar(lb=0, ub=None, name="L", vtype=gurobi.GRB.CONTINUOUS)
Pe = m.addVar(lb=0, ub=None, name="Pe", vtype=gurobi.GRB.CONTINUOUS)

# Objective function
m.setObjective(4.29*M + 6.96*D + 1.97*J + 6.01*P + 8.03*G + 8.83*L + 3.7*Pe, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*M + 19*D + 23*J + 15*P + 20*G + 8*L + Pe <= 606)
m.addConstr(15*M + 11*D + 10*J + P + 18*G + 6*L + 23*Pe <= 1028)

m.addConstr(23*J + 15*P + 8*L >= 49)
m.addConstr(10*J + 18*G + 6*L >= 91)
m.addConstr(10*J + 6*L + 23*Pe >= 91)
m.addConstr(P + 6*L + 23*Pe >= 91)
m.addConstr(15*M + 10*J + 18*G >= 91)
m.addConstr(11*D + 18*G + 23*Pe >= 91)
m.addConstr(P + 18*G + 6*L >= 91)
m.addConstr(10*J + P + 6*L >= 91)
m.addConstr(15*M + 10*J + 6*L >= 91)
m.addConstr(11*D + P + 6*L >= 91)
m.addConstr(11*D + 10*J + 23*Pe >= 91)
m.addConstr(18*G + 6*L + 23*Pe >= 91)
m.addConstr(15*M + 10*J + P >= 91)
m.addConstr(11*D + 18*G + 6*L >= 91)
m.addConstr(15*M + 11*D + 6*L >= 91)
m.addConstr(15*M + 11*D + P >= 91)

# ... (rest of the constraints)

# Optimize the model
m.optimize()

if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("M: ", M.varValue)
    print("D: ", D.varValue)
    print("J: ", J.varValue)
    print("P: ", P.varValue)
    print("G: ", G.varValue)
    print("L: ", L.varValue)
    print("Pe: ", Pe.varValue)
else:
    print("Model is infeasible")
