
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Define the variables
jean = m.addVar(name="jean", lb=0)  
bill = m.addVar(name="bill", lb=0)  
ringo = m.addVar(name="ringo", lb=0)  
dale = m.addVar(name="dale", lb=0)  
paul = m.addVar(name="paul", lb=0)  

# Objective function
m.setObjective(3.28 * jean + 1.18 * bill + 5.65 * ringo + 3.31 * dale + 2.85 * paul, sense=m.MINIMIZE)

# Constraints
m.addConstr(1.09 * jean + 3.51 * ringo >= 9, name="jean_ringo_dollar_cost")
m.addConstr(1.61 * bill + 3.51 * ringo + 2.87 * paul >= 20, name="bill_ringo_paul_dollar_cost")
m.addConstr(1.09 * jean + 1.61 * bill + 3.51 * ringo + 5.37 * dale + 2.87 * paul >= 20, name="all_dollar_cost")

m.addConstr(4.75 * ringo + 0.01 * paul >= 21, name="ringo_paul_organization")
m.addConstr(0.7 * bill + 4.78 * dale >= 30, name="bill_dale_organization")
m.addConstr(0.7 * bill + 0.01 * paul >= 26, name="bill_paul_organization")
m.addConstr(3.74 * ringo + 4.78 * dale >= 36, name="ringo_dale_organization")
m.addConstr(4.78 * dale + 0.01 * paul >= 25, name="dale_paul_organization")
m.addConstr(0.7 * bill + 3.74 * ringo >= 34, name="bill_ringo_organization")
m.addConstr(4.75 * jean + 4.78 * dale + 0.01 * paul >= 33, name="jean_dale_paul_organization")
m.addConstr(0.7 * bill + 3.74 * ringo + 0.01 * paul >= 33, name="bill_ringo_paul_organization")
m.addConstr(4.75 * jean + 4.78 * dale + 0.01 * paul >= 36, name="jean_dale_paul_organization_2")
m.addConstr(0.7 * bill + 3.74 * ringo + 0.01 * paul >= 36, name="bill_ringo_paul_organization_2")

m.addConstr(1.11 * bill + 1.77 * paul >= 37, name="bill_paul_likelihood")
m.addConstr(0.6 * jean + 1.11 * bill >= 27, name="jean_bill_likelihood")
m.addConstr(3.56 * ringo + 1.77 * paul >= 33, name="ringo_paul_likelihood")
m.addConstr(4.22 * dale + 1.77 * paul >= 17, name="dale_paul_likelihood")
m.addConstr(3.56 * ringo + 4.22 * dale >= 18, name="ringo_dale_likelihood")
m.addConstr(0.6 * jean + 1.11 * bill + 3.56 * ringo + 4.22 * dale + 1.77 * paul >= 18, name="all_likelihood")

m.addConstr(4.72 * jean + 5.1 * dale >= 15, name="jean_dale_work_quality")
m.addConstr(2.11 * ringo + 5.1 * dale >= 17, name="ringo_dale_work_quality")
m.addConstr(4.72 * jean + 2.11 * ringo >= 15, name="jean_ringo_work_quality")
m.addConstr(2.11 * ringo + 0.07 * paul >= 38, name="ringo_paul_work_quality")

m.addConstr(5 * jean - 5 * bill >= 0, name="jean_bill_constraint")
m.addConstr(jean - 10 * dale >= 0, name="jean_dale_constraint")

m.addConstr(1.09 * jean + 1.61 * bill <= 89, name="jean_bill_dollar_cost")
m.addConstr(1.09 * jean + 1.61 * bill + 2.87 * paul <= 24, name="jean_bill_paul_dollar_cost")

# Solve the model
m.optimize()

# Output the solution
if m.status == m.OPTIMAL:
    print("Optimal solution found.")
    print(f"Jean: {jean.varValue}")
    print(f"Bill: {bill.varValue}")
    print(f"Ringo: {ringo.varValue}")
    print(f"Dale: {dale.varValue}")
    print(f"Paul: {paul.varValue}")
else:
    print("No optimal solution found.")
