
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Optimization")

# Create variables
bobby_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby_hours")
bill_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="bill_hours")

# Set objective function
model.setObjective(8 * bobby_hours + 5 * bill_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * bobby_hours + 27 * bill_hours >= 49, "Work_Quality_Min")
model.addConstr(21 * bobby_hours + 26 * bill_hours >= 50, "Organization_Score_Min")
model.addConstr(-4 * bobby_hours + 3 * bill_hours >= 0, "Custom_Constraint_1")
model.addConstr(7 * bobby_hours + 27 * bill_hours <= 93, "Work_Quality_Max")
model.addConstr(21 * bobby_hours + 26 * bill_hours <= 115, "Organization_Score_Max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Bobby's Hours: {bobby_hours.x}")
    print(f"Bill's Hours: {bill_hours.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

