
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables: hours worked by Bobby can be non-integer, but hours worked by Bill must be integer
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Objective function: maximize 8*x0 + 5*x1
m.setObjective(8*x0 + 5*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x0 + 27*x1 >= 49, name="combined_work_quality_rating_min")
m.addConstr(21*x0 + 26*x1 >= 50, name="combined_organization_score_min")
m.addConstr(-4*x0 + 3*x1 >= 0, name="linear_constraint")
m.addConstr(7*x0 + 27*x1 <= 93, name="combined_work_quality_rating_max")
m.addConstr(21*x0 + 26*x1 <= 115, name="combined_organization_score_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x0.x}")
    print(f"Hours worked by Bill: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
