
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # Hours worked by Bobby
    x1 = model.addVar(name="hours_worked_by_Bill", lb=0, integrality=gurobi.GRB.INTEGER)  # Hours worked by Bill

    # Objective function: Maximize 8 * x0 + 5 * x1
    model.setObjective(8 * x0 + 5 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Work quality ratings
    model.addConstr(7 * x0 + 27 * x1 >= 49, name="work_quality_rating_min")
    model.addConstr(7 * x0 + 27 * x1 <= 93, name="work_quality_rating_max")

    # Organization scores
    model.addConstr(21 * x0 + 26 * x1 >= 50, name="organization_score_min")
    model.addConstr(21 * x0 + 26 * x1 <= 115, name="organization_score_max")

    # Linear constraint
    model.addConstr(-4 * x0 + 3 * x1 >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Bobby: {x0.varValue}")
        print(f"Hours worked by Bill: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
