
from gurobipy import Model, GRB

# Create a new model
model = Model("Umami Optimization")

# Create variables
sashimi = model.addVar(vtype=GRB.INTEGER, name="sashimi")
ham_sandwiches = model.addVar(vtype=GRB.INTEGER, name="ham_sandwiches")
milkshakes = model.addVar(vtype=GRB.INTEGER, name="milkshakes")
potatoes = model.addVar(vtype=GRB.INTEGER, name="potatoes")
kale_salads = model.addVar(vtype=GRB.INTEGER, name="kale_salads")

# Set objective function
model.setObjective(9 * sashimi + 9 * ham_sandwiches + 5 * milkshakes + 9 * potatoes + 8 * kale_salads, GRB.MINIMIZE)

# Add constraints
model.addConstr(11 * ham_sandwiches + 9 * potatoes >= 66, "c1")
model.addConstr(8 * sashimi + 9 * potatoes >= 40, "c2")
model.addConstr(17 * milkshakes + 9 * potatoes >= 33, "c3")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 9 * potatoes >= 57, "c4")
model.addConstr(8 * sashimi + 11 * ham_sandwiches + 18 * kale_salads >= 57, "c5")
model.addConstr(8 * sashimi + 17 * milkshakes + 9 * potatoes >= 57, "c6")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 18 * kale_salads >= 57, "c7")
model.addConstr(17 * milkshakes + 9 * potatoes + 18 * kale_salads >= 57, "c8")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 9 * potatoes >= 63, "c9")
model.addConstr(8 * sashimi + 11 * ham_sandwiches + 18 * kale_salads >= 63, "c10")
model.addConstr(8 * sashimi + 17 * milkshakes + 9 * potatoes >= 63, "c11")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 18 * kale_salads >= 63, "c12")
model.addConstr(17 * milkshakes + 9 * potatoes + 18 * kale_salads >= 63, "c13")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 9 * potatoes >= 43, "c14")
model.addConstr(8 * sashimi + 11 * ham_sandwiches + 18 * kale_salads >= 43, "c15")
model.addConstr(8 * sashimi + 17 * milkshakes + 9 * potatoes >= 43, "c16")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 18 * kale_salads >= 43, "c17")
model.addConstr(17 * milkshakes + 9 * potatoes + 18 * kale_salads >= 43, "c18")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 9 * potatoes >= 64, "c19")
model.addConstr(8 * sashimi + 11 * ham_sandwiches + 18 * kale_salads >= 64, "c20")
model.addConstr(8 * sashimi + 17 * milkshakes + 9 * potatoes >= 64, "c21")
model.addConstr(11 * ham_sandwiches + 17 * milkshakes + 18 * kale_salads >= 64, "c22")
model.addConstr(17 * milkshakes + 9 * potatoes + 18 * kale_salads >= 64, "c23")
model.addConstr(8 * sashimi + 11 * ham_sandwiches + 17 * milkshakes + 9 * potatoes + 18 * kale_salads >= 64, "c24")
model.addConstr(-10 * sashimi + 1 * ham_sandwiches >= 0, "c25")
model.addConstr(8 * ham_sandwiches - 7 * kale_salads >= 0, "c26")
model.addConstr(8 * sashimi + 11 * ham_sandwiches + 18 * kale_salads <= 150, "c27")
model.addConstr(11 * ham_sandwiches + 9 * potatoes + 18 * kale_salads <= 194, "c28")
model.addConstr(8 * sashimi + 9 * potatoes + 18 * kale_salads <= 217, "c29")
model.addConstr(17 * milkshakes + 9 * potatoes + 18 * kale_salads <= 282, "c30")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
