
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables as integers
sashimi = m.addVar(vtype=GRB.INTEGER, name="sashimi")
ham_sandwiches = m.addVar(vtype=GRB.INTEGER, name="ham_sandwiches")
milkshakes = m.addVar(vtype=GRB.INTEGER, name="milkshakes")
potatoes = m.addVar(vtype=GRB.INTEGER, name="potatoes")
kale_salads = m.addVar(vtype=GRB.INTEGER, name="kale_salads")

# Objective function
m.setObjective(9*sashimi + 9*ham_sandwiches + 5*milkshakes + 9*potatoes + 8*kale_salads, GRB.MINIMIZE)

# Constraints
# Umami index constraints for combinations of items (example)
m.addConstr(11*ham_sandwiches + 9*potatoes >= 66)  # Total umami from ham sandwiches and potatoes
m.addConstr(8*sashimi + 9*potatoes >= 40)          # Total umami from sashimi and potatoes
m.addConstr(17*milkshakes + 9*potatoes >= 33)      # Total umami from milkshakes and potatoes

# Additional constraints (example)
m.addConstr(-10*sashimi + ham_sandwiches >= 0)     # Linear inequality constraint
m.addConstr(8*ham_sandwiches - 7*kale_salads >= 0) # Another linear inequality constraint

# Umami index upper bounds for combinations (example)
m.addConstr(8*sashimi + 11*ham_sandwiches + 18*kale_salads <= 150)

# Other constraints
for var in [sashimi, ham_sandwiches, milkshakes, potatoes, kale_salads]:
    m.addConstr(var >= 0)  # Non-negativity constraint

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found. Status:", m.status)
