
from gurobipy import Model, GRB

# Create a new model
model = Model("Supplement Optimization")

# Create variables
vitamin_k = model.addVar(vtype=GRB.INTEGER, name="vitamin_k")
zinc = model.addVar(vtype=GRB.CONTINUOUS, name="zinc")
potassium = model.addVar(vtype=GRB.CONTINUOUS, name="potassium")

# Set objective function
model.setObjective(3 * vitamin_k + 2 * zinc + 8 * potassium, GRB.MINIMIZE)

# Add constraints based on resource attributes
digestive_support = {'vitamin_k': 2.2, 'zinc': 0.26, 'potassium': 2.58, 'upper_bound': 71}
cognitive_performance = {'vitamin_k': 3.99, 'zinc': 2.9, 'potassium': 2.61, 'upper_bound': 61}
immune_support = {'vitamin_k': 0.26, 'zinc': 0.79, 'potassium': 4.67, 'upper_bound': 64}

# Constraint: Total combined digestive support index limits
model.addConstr(2.2 * vitamin_k + 0.26 * zinc >= 22, "digestive_support_vk_zn")
model.addConstr(0.26 * zinc + 2.58 * potassium >= 13, "digestive_support_zn_po")
model.addConstr(2.2 * vitamin_k + 0.26 * zinc + 2.58 * potassium >= 13, "digestive_support_all")

# Constraint: Total combined cognitive performance index limits
model.addConstr(3.99 * vitamin_k + 2.9 * zinc >= 13, "cognitive_performance_vk_zn")
model.addConstr(3.99 * vitamin_k + 2.61 * potassium >= 12, "cognitive_performance_vk_po")
model.addConstr(3.99 * vitamin_k + 2.9 * zinc + 2.61 * potassium >= 11, "cognitive_performance_all_1")
model.addConstr(3.99 * vitamin_k + 2.9 * zinc + 2.61 * potassium >= 11, "cognitive_performance_all_2")  # Redundant

# Constraint: Total combined immune support index limits
model.addConstr(0.79 * zinc + 4.67 * potassium >= 8, "immune_support_zn_po")
model.addConstr(0.26 * vitamin_k + 0.79 * zinc >= 14, "immune_support_vk_zn")
model.addConstr(0.26 * vitamin_k + 0.79 * zinc + 4.67 * potassium >= 14, "immune_support_all")

# Additional constraints
model.addConstr(3 * zinc - 7 * potassium >= 0, "zinc_potassium_relation")
model.addConstr(2.9 * zinc + 2.61 * potassium <= 38, "cognitive_performance_zn_po_upper")
model.addConstr(3.99 * vitamin_k + 2.9 * zinc <= 22, "cognitive_performance_vk_zn_upper")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Vitamin K:', vitamin_k.x)
    print('Zinc:', zinc.x)
    print('Potassium:', potassium.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

