
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milligrams of vitamin K", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="milligrams of zinc")
x2 = model.addVar(name="milligrams of potassium")

# Define the objective function
model.setObjective(3 * x0 + 2 * x1 + 8 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
# Individual index constraints
model.addConstr(2.2 * x0 <= 71)
model.addConstr(3.99 * x0 <= 61)
model.addConstr(0.26 * x0 <= 64)
model.addConstr(0.26 * x1 <= 71)
model.addConstr(2.9 * x1 <= 61)
model.addConstr(0.79 * x1 <= 64)
model.addConstr(2.58 * x2 <= 71)
model.addConstr(2.61 * x2 <= 61)
model.addConstr(4.67 * x2 <= 64)

# Combined digestive support index constraints
model.addConstr(2.2 * x0 + 0.26 * x1 >= 22)
model.addConstr(0.26 * x1 + 2.58 * x2 >= 13)
model.addConstr(2.2 * x0 + 0.26 * x1 + 2.58 * x2 >= 13)

# Combined cognitive performance index constraints
model.addConstr(3.99 * x0 + 2.9 * x1 >= 13)
model.addConstr(3.99 * x0 + 2.61 * x2 >= 12)
model.addConstr(3.99 * x0 + 2.9 * x1 + 2.61 * x2 >= 11)

# Combined immune support index constraints
model.addConstr(0.79 * x1 + 4.67 * x2 >= 8)
model.addConstr(0.26 * x0 + 0.79 * x1 >= 14)
model.addConstr(0.26 * x0 + 0.79 * x1 + 4.67 * x2 >= 14)

# Additional constraints
model.addConstr(3 * x1 - 7 * x2 >= 0)
model.addConstr(2.9 * x1 + 2.61 * x2 <= 38)
model.addConstr(3.99 * x0 + 2.9 * x1 <= 22)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin K: {x0.varValue}")
    print(f"Milligrams of zinc: {x1.varValue}")
    print(f"Milligrams of potassium: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
