
import gurobi as gp

def optimization_problem():
    # Create a new model
    m = gp.Model("optimization")

    # Define variables
    M = m.addVar(lb=0, name="M")  
    H = m.addVar(name="H")
    J = m.addVar(name="J")
    R = m.addVar(name="R")
    L = m.addVar(name="L")
    G = m.addVar(name="G")
    B = m.addVar(name="B", vtype=gp.GRB.INTEGER)  
    
    # Objective function
    m.setObjective(8*M**2 + 3*M*H + 9*M*J + 2*M*R + 5*M*L + 2*M*G + 6*M*B + 
                   3*H*J + 4*H*R + 8*H*L + 9*H*G + 4*H*B + 
                   6*J**2 + 5*J*R + 3*J*L + 2*J*G + 9*J*B + 
                   4*R**2 + 5*R*G + 4*R*B + 
                   2*L**2 + 8*G**2 + M*G + B*G + B**2 + 
                   3*M + H + 7*J + 5*R + L + 3*G + 7*B, 
                   gp.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(9*M == 1, name="Mary_work_quality")
    m.addConstr(M == 1, name="Mary_paperwork")
    m.addConstr(9*H == 9, name="Hank_work_quality")
    m.addConstr(2*H == 2, name="Hank_paperwork")
    m.addConstr(4*J == 4, name="Jean_work_quality")
    m.addConstr(8*J == 8, name="Jean_paperwork")
    m.addConstr(8*R == 8, name="Ringo_work_quality")
    m.addConstr(11*R == 11, name="Ringo_paperwork")
    m.addConstr(6*L == 6, name="Laura_work_quality")
    m.addConstr(10*L == 10, name="Laura_paperwork")
    m.addConstr(6*G == 6, name="George_work_quality")
    m.addConstr(4*G == 4, name="George_paperwork")
    m.addConstr(1*B == 1, name="Bill_work_quality")
    m.addConstr(11*B == 11, name="Bill_paperwork")

    m.addConstr(9*H + 4*J >= 24, name="Hank_Jean_work_quality")
    m.addConstr(6*L + 1*B >= 30, name="Laura_Bill_work_quality")
    m.addConstr(6*H + 6*G >= 30, name="Hank_George_work_quality")
    m.addConstr(9*H + 1*B >= 23, name="Hank_Bill_work_quality")
    m.addConstr(9*M + 8*R >= 26, name="Mary_Ringo_work_quality")
    m.addConstr(9*H + 10*L >= 11, name="Hank_Laura_work_quality")
    m.addConstr(8*R + 10*L + 1*B >= 23, name="Ringo_Laura_Bill_work_quality")
    m.addConstr(M**2 + L**2 + B**2 >= 23, name="Mary_Laura_Bill_work_quality_squared")
    m.addConstr(M + 4*J + 6*L >= 23, name="Mary_Jean_Laura_work_quality")
    m.addConstr(9*M + H + B >= 23, name="Mary_Hank_Bill_work_quality")
    m.addConstr(6*H + 4*G + B >= 23, name="Hank_George_Bill_work_quality")
    m.addConstr(M + 4*J + B >= 23, name="Mary_Jean_Bill_work_quality")
    m.addConstr(M + 6*G + B >= 23, name="Mary_George_Bill_work_quality")
    m.addConstr(H + 10*L + B >= 23, name="Hank_Laura_Bill_work_quality")
    m.addConstr(6*H + 4*J + 6*G >= 23, name="Hank_Jean_George_work_quality")
    m.addConstr(8*R + 10*L + B >= 25, name="Ringo_Laura_Bill_work_quality_improved")
    m.addConstr(M + 10*L + B >= 27, name="Mary_Laura_Bill_work_quality_improved")
    m.addConstr(M**2 + J**2 + L**2 >= 25, name="Mary_Jean_Laura_work_quality_squared_improved")
    m.addConstr(9*M + H + B >= 27, name="Mary_Hank_Bill_work_quality_improved")
    m.addConstr(6*H + 4*G + B >= 27, name="Hank_George_Bill_work_quality_improved")
    m.addConstr(M**2 + J**2 + B**2 >= 27, name="Mary_Jean_Bill_work_quality_squared_improved")
    m.addConstr(M + 6*G + B >= 27, name="Mary_George_Bill_work_quality_improved")
    m.addConstr(H + 10*L + B >= 27, name="Hank_Laura_Bill_work_quality_improved")
    m.addConstr(6*H + 4*J + 6*G >= 27, name="Hank_Jean_George_work_quality_improved")
    m.addConstr(11*R**2 + 10*L**2 + B**2 >= 29, name="Ringo_Laura_Bill_work_quality_squared_improved")
    m.addConstr(M**2 + L**2 + B**2 >= 29, name="Mary_Laura_Bill_work_quality_squared_improved_2")
    m.addConstr(M**2 + J**2 + L**2 >= 29, name="Mary_Jean_Laura_work_quality_squared_improved_2")
    m.addConstr(9*M + H + B >= 29, name="Mary_Hank_Bill_work_quality_improved_2")
    m.addConstr(11*H**2 + 10*G**2 + B**2 >= 29, name="Hank_George_Bill_work_quality_squared_improved")
    m.addConstr(M**2 + J**2 + B**2 >= 29, name="Mary_Jean_Bill_work_quality_squared_improved_2")
    m.addConstr(M + 6*G + B >= 29, name="Mary_George_Bill_work_quality_improved_2")
    m.addConstr(11*H**2 + 10*L**2 + B**2 >= 29, name="Hank_Laura_Bill_work_quality_squared_improved_2")
    m.addConstr(6*H**2 + 4*J**2 + 6*G**2 >= 25, name="Hank_Jean_George_work_quality_squared")
    m.addConstr(8*R + 10*L + B >= 30, name="Ringo_Laura_Bill_work_quality_final")
    m.addConstr(M + 10*L + B >= 30, name="Mary_Laura_Bill_work_quality_final")
    m.addConstr(M**2 + J**2 + L**2 >= 30, name="Mary_Jean_Laura_work_quality_squared_final")
    m.addConstr(9*M + H + B >= 30, name="Mary_Hank_Bill_work_quality_final")
    m.addConstr(11*H**2 + 10*G**2 + B**2 >= 30, name="Hank_George_Bill_work_quality_squared_final")
    m.addConstr(M**2 + G**2 + B**2 >= 30, name="Mary_George_Bill_work_quality_squared_final")
    m.addConstr(11*H**2 + 10*L**2 + B**2 >= 30, name="Hank_Laura_Bill_work_quality_squared_final")
    m.addConstr(6*H**2 + 4*J**2 + 6*G**2 >= 30, name="Hank_Jean_George_work_quality_squared_final")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("M: ", M.varValue)
        print("H: ", H.varValue)
        print("J: ", J.varValue)
        print("R: ", R.varValue)
        print("L: ", L.varValue)
        print("G: ", G.varValue)
        print("B: ", B.varValue)
    else:
        print("No solution found")

optimization_problem()
