
import gurobipy as gp

# Create a new model
model = gp.Model("Supplement_Optimization")

# Define decision variables
vitamin_B4 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")
iron = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")
magnesium = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="magnesium")
fiber = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fiber")
vitamin_B1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B1")
vitamin_B2 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B2")
vitamin_E = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_E")
vitamin_B7 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B7")


# Define objective function
model.setObjective(2.91 * vitamin_B4 + 8.45 * iron + 1.9 * magnesium + 1.08 * fiber + 6.88 * vitamin_B1 + 3.4 * vitamin_B2 + 3.55 * vitamin_E + 8.47 * vitamin_B7, gp.GRB.MINIMIZE)

# Define resource constraints
resources = {
    'r0': {'upper_bound': 300, 'coeffs': [8, 7, 20, 4, 20, 20, 16, 18]},
    'r1': {'upper_bound': 376, 'coeffs': [4, 4, 5, 13, 18, 7, 5, 17]},
    'r2': {'upper_bound': 782, 'coeffs': [14, 15, 16, 5, 7, 13, 12, 16]},
    'r3': {'upper_bound': 796, 'coeffs': [12, 18, 6, 14, 6, 5, 3, 6]},
    'r4': {'upper_bound': 663, 'coeffs': [20, 6, 18, 20, 11, 18, 4, 20]}
}

variables = [vitamin_B4, iron, magnesium, fiber, vitamin_B1, vitamin_B2, vitamin_E, vitamin_B7]

for r, data in resources.items():
    model.addConstr(gp.quicksum(data['coeffs'][i] * variables[i] for i in range(len(variables))) <= data['upper_bound'], name=r)


# Add other constraints (provided in the prompt)
model.addConstr(8 * vitamin_B4 + 20 * vitamin_B2 >= 29)
model.addConstr(8 * vitamin_B4 + 4 * fiber >= 28)
# ... (Add all the remaining constraints similarly)
model.addConstr(-2 * vitamin_E + 1 * vitamin_B7 >= 0)
model.addConstr(4 * vitamin_B2 - 4 * vitamin_E >= 0)
# ... (Add all the remaining constraints similarly)


# Optimize the model
model.optimize()

# Print the solution status
status = model.status
if status == gp.GRB.OPTIMAL:
    print("Optimal solution found")
    # Print the optimal values of the decision variables
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
elif status == gp.GRB.UNBOUNDED:
    print("Model is unbounded")
elif status == gp.GRB.INF_OR_UNBD:
    print("Model is infeasible or unbounded")
else:
    print(f"Optimization terminated with status {status}")

