
import gurobi as gp

# Define the variables
m = gp.Model("optimization_problem")

# Define the variables with their bounds
x0 = m.addVar(lb=0, name="milligrams of vitamin B4")
x1 = m.addVar(lb=0, name="milligrams of iron")
x2 = m.addVar(lb=0, name="milligrams of magnesium")
x3 = m.addVar(lb=0, name="grams of fiber")
x4 = m.addVar(lb=0, name="milligrams of vitamin B1")
x5 = m.addVar(lb=0, name="milligrams of vitamin B2")
x6 = m.addVar(lb=0, name="milligrams of vitamin E")
x7 = m.addVar(lb=0, name="milligrams of vitamin B7")

# Define the objective function
m.setObjective(2.91 * x0 + 8.45 * x1 + 1.9 * x2 + 1.08 * x3 + 6.88 * x4 + 3.4 * x5 + 3.55 * x6 + 8.47 * x7, gp.GRB.MINIMIZE)

# Add constraints
# Muscle growth index constraints
m.addConstr(8 * x0 + 7 * x1 + 20 * x2 + 4 * x3 + 20 * x4 + 20 * x5 + 16 * x6 + 18 * x7 >= 29)
m.addConstr(8 * x0 + 7 * x1 + 20 * x2 + 4 * x3 + 20 * x4 + 20 * x5 + 16 * x6 + 18 * x7 >= 28)
m.addConstr(20 * x2 + 20 * x5 + 16 * x6 + 18 * x7 + 8 * x0 + 7 * x1 >= 34)

# Kidney support index constraints
m.addConstr(4 * x0 + 4 * x1 + 5 * x2 + 13 * x3 + 18 * x4 + 7 * x5 + 5 * x6 + 17 * x7 <= 376)

# Immune support index constraints
m.addConstr(14 * x0 + 15 * x1 + 16 * x2 + 5 * x3 + 7 * x4 + 13 * x5 + 12 * x6 + 16 * x7 <= 782)

# Energy stability index constraints
m.addConstr(12 * x0 + 18 * x1 + 6 * x2 + 14 * x3 + 6 * x4 + 5 * x5 + 3 * x6 + 6 * x7 <= 796)

# Cognitive performance index constraints
m.addConstr(20 * x0 + 6 * x1 + 18 * x2 + 20 * x3 + 11 * x4 + 18 * x5 + 4 * x6 + 20 * x7 <= 663)

# Integrality constraints
m.addConstr(x1, gp.GRB.INTEGER)
m.addConstr(x2, gp.GRB.INTEGER)
m.addConstr(x3, gp.GRB.INTEGER)
m.addConstr(x4, gp.GRB.INTEGER)
m.addConstr(x5, gp.GRB.INTEGER)
m.addConstr(x7, gp.GRB.INTEGER)

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of vitamin B4: ", x0.varValue)
    print("Milligrams of iron: ", x1.varValue)
    print("Milligrams of magnesium: ", x2.varValue)
    print("Grams of fiber: ", x3.varValue)
    print("Milligrams of vitamin B1: ", x4.varValue)
    print("Milligrams of vitamin B2: ", x5.varValue)
    print("Milligrams of vitamin E: ", x6.varValue)
    print("Milligrams of vitamin B7: ", x7.varValue)
else:
    print("The problem is infeasible")
