
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apples = m.addVar(lb=0, name="apples")
eggs = m.addVar(lb=0, name="eggs")
ramen = m.addVar(lb=0, name="ramen")

# Set objective function
m.setObjective(9.29 * apples**2 + 3.05 * apples * eggs + 9.45 * eggs * ramen + 7.93 * apples + 6.27 * eggs + 8.08 * ramen, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.43 * eggs + 2.94 * ramen >= 31, "fiber_constraint1")
m.addConstr(2.67 * apples**2 + 2.94 * ramen**2 >= 16, "fiber_constraint2")
m.addConstr(0.43 * eggs**2 + 2.94 * ramen**2 <= 97, "fiber_constraint3")
m.addConstr(2.67 * apples + 0.43 * eggs <= 90, "fiber_constraint4")
m.addConstr(2.67 * apples + 0.43 * eggs + 2.94 * ramen <= 90, "fiber_constraint5")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('apples:', apples.x)
    print('eggs:', eggs.x)
    print('ramen:', ramen.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

