
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
apples = m.addVar(vtype=GRB.CONTINUOUS, name="apples", lb=0)
eggs = m.addVar(vtype=GRB.CONTINUOUS, name="eggs", lb=0)
bowls_of_instant_ramens = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramens", lb=0)

# Define the objective function
m.setObjective(9.29 * apples**2 + 3.05 * apples * eggs + 9.45 * eggs * bowls_of_instant_ramens + 
               7.93 * apples + 6.27 * eggs + 8.08 * bowls_of_instant_ramens, GRB.MAXIMIZE)

# Define constraints
m.addConstr(2.67 * apples + 0.43 * eggs + 2.94 * bowls_of_instant_ramens <= 116, name="Total_Fiber")
m.addConstr(0.43 * eggs + 2.94 * bowls_of_instant_ramens >= 31, name="Eggs_and_Ramens_Minimum")
m.addConstr((apples**2) * 2.67 + (bowls_of_instant_ramens**2) * 2.94 >= 16, name="Apples_and_Ramens_Squared_Minimum")
m.addConstr((eggs**2) * 0.43 + (bowls_of_instant_ramens**2) * 2.94 <= 97, name="Eggs_and_Ramens_Squared_Maximum")
m.addConstr(2.67 * apples + 0.43 * eggs <= 90, name="Apples_and_Eggs_Fiber_Maximum")
m.addConstr(2.67 * apples + 0.43 * eggs + 2.94 * bowls_of_instant_ramens <= 90, name="All_Items_Fiber_Maximum")

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print("Objective:", m.objVal)
