
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="bagged_salads", lb=0, ub=None)
x1 = m.addVar(name="strips_of_bacon", lb=0, ub=None)
x2 = m.addVar(name="kiwis", lb=0, ub=None)
x3 = m.addVar(name="cornichons", lb=0, ub=None)
x4 = m.addVar(name="fruit_salads", lb=0, ub=None)
x5 = m.addVar(name="bananas", lb=0, ub=None)
x6 = m.addVar(name="eggs", lb=0, ub=None)

# Objective function
m.setObjective(2.18*x0 + 5.08*x1 + 8.26*x2 + 8.58*x3 + 4.98*x4 + 5.83*x5 + 4.0*x6, gurobi.GRB.MINIMIZE)

# Constraints
# Fiber constraints
m.addConstr(16*x0 + 18*x1 + 19*x2 + 15*x3 + 11*x4 + 10*x5 + 28*x6 >= 62)
m.addConstr(18*x1 + 19*x2 + 15*x3 >= 77)
m.addConstr(11*x4 + 10*x5 + 28*x6 >= 63)
m.addConstr(16*x0 + 28*x6 >= 34)
m.addConstr(16*x0 + 15*x3 >= 52)
m.addConstr(19*x2 + 11*x4 + 10*x5 >= 28)
m.addConstr(15*x3 + 11*x4 >= 65)

# Healthiness rating constraints
m.addConstr(5*x0 + 21*x1 + 14*x2 + 27*x3 + 34*x4 + 18*x5 + 14*x6 >= 113)
m.addConstr(5*x0 + 27*x3 >= 66)
m.addConstr(14*x2 + 34*x4 >= 104)
m.addConstr(18*x5 + 14*x6 >= 122)
m.addConstr(21*x1 + 14*x2 >= 105)
m.addConstr(21*x1 + 11*x4 >= 95)
m.addConstr(5*x0 + 11*x4 >= 126)
m.addConstr(5*x0 + 21*x1 + 14*x6 >= 75)
m.addConstr(5*x0 + 11*x4 + 14*x6 >= 75)
m.addConstr(5*x0 + 21*x1 + 14*x6 >= 132)
m.addConstr(5*x0 + 11*x4 + 14*x6 >= 132)

# Carbohydrates constraints
m.addConstr(24*x0 + 14*x1 + 23*x2 + 21*x3 + 11*x4 + 12*x5 + 17*x6 >= 97)
m.addConstr(24*x0 + 12*x5 >= 97)
m.addConstr(24*x0 + 11*x4 >= 43)
m.addConstr(14*x1 + 11*x4 >= 80)
m.addConstr(23*x2 + 21*x3 >= 116)

# Umami index constraints
m.addConstr(6*x0 + 26*x1 + 27*x2 + 8*x3 + 23*x4 + 18*x5 + 13*x6 >= 116)

# Calcium constraints
m.addConstr(7*x0 + 3*x1 + 17*x2 + 13*x3 + 26*x4 + 24*x5 + 3*x6 >= 142)

# Solve the problem
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bagged_salads: ", x0.x)
    print("strips_of_bacon: ", x1.x)
    print("kiwis: ", x2.x)
    print("cornichons: ", x3.x)
    print("fruit_salads: ", x4.x)
    print("bananas: ", x5.x)
    print("eggs: ", x6.x)
else:
    print("No optimal solution found")
